/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractLocator;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DecoratedFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class RelativeLocator
extends AbstractLocator {
    protected double relativeX;
    protected double relativeY;
    protected boolean isTransform;

    public RelativeLocator() {
        this(0.0, 0.0, false);
    }

    public RelativeLocator(double d, double d2) {
        this(d, d2, false);
    }

    public RelativeLocator(double d, double d2, boolean bl) {
        this.relativeX = d;
        this.relativeY = d2;
        this.isTransform = bl;
    }

    @Override
    public Point2D.Double locate(Figure figure) {
        Cloneable cloneable;
        Rectangle2D.Double double_ = figure.getBounds();
        if (figure instanceof DecoratedFigure && ((DecoratedFigure)figure).getDecorator() != null && (cloneable = figure.get(AttributeKeys.DECORATOR_INSETS)) != null) {
            cloneable.addTo(double_);
        }
        if (this.isTransform) {
            cloneable = new Point2D.Double(double_.x + double_.width * this.relativeX, double_.y + double_.height * this.relativeY);
            if (figure.get(AttributeKeys.TRANSFORM) != null) {
                figure.get(AttributeKeys.TRANSFORM).transform((Point2D)cloneable, (Point2D)cloneable);
            }
        } else {
            if (figure.get(AttributeKeys.TRANSFORM) != null) {
                Rectangle2D rectangle2D = figure.get(AttributeKeys.TRANSFORM).createTransformedShape(double_).getBounds2D();
                double_.x = rectangle2D.getX();
                double_.y = rectangle2D.getY();
                double_.width = rectangle2D.getWidth();
                double_.height = rectangle2D.getHeight();
            }
            cloneable = new Point2D.Double(double_.x + double_.width * this.relativeX, double_.y + double_.height * this.relativeY);
        }
        return cloneable;
    }

    public static Locator east() {
        return RelativeLocator.east(false);
    }

    public static Locator east(boolean bl) {
        return new RelativeLocator(1.0, 0.5, bl);
    }

    public static Locator north() {
        return RelativeLocator.north(false);
    }

    public static Locator north(boolean bl) {
        return new RelativeLocator(0.5, 0.0, bl);
    }

    public static Locator west() {
        return RelativeLocator.west(false);
    }

    public static Locator west(boolean bl) {
        return new RelativeLocator(0.0, 0.5, bl);
    }

    public static Locator northEast() {
        return RelativeLocator.northEast(false);
    }

    public static Locator northEast(boolean bl) {
        return new RelativeLocator(1.0, 0.0, bl);
    }

    public static Locator northWest() {
        return RelativeLocator.northWest(false);
    }

    public static Locator northWest(boolean bl) {
        return new RelativeLocator(0.0, 0.0, bl);
    }

    public static Locator south() {
        return RelativeLocator.south(false);
    }

    public static Locator south(boolean bl) {
        return new RelativeLocator(0.5, 1.0, bl);
    }

    public static Locator southEast() {
        return RelativeLocator.southEast(false);
    }

    public static Locator southEast(boolean bl) {
        return new RelativeLocator(1.0, 1.0, bl);
    }

    public static Locator southWest() {
        return RelativeLocator.southWest(false);
    }

    public static Locator southWest(boolean bl) {
        return new RelativeLocator(0.0, 1.0, bl);
    }

    public static Locator center() {
        return RelativeLocator.center(false);
    }

    public static Locator center(boolean bl) {
        return new RelativeLocator(0.5, 0.5, bl);
    }

    @Override
    public void write(DOMOutput dOMOutput) {
        dOMOutput.addAttribute("relativeX", this.relativeX, 0.5);
        dOMOutput.addAttribute("relativeY", this.relativeY, 0.5);
    }

    @Override
    public void read(DOMInput dOMInput) {
        this.relativeX = dOMInput.getAttribute("relativeX", 0.5);
        this.relativeY = dOMInput.getAttribute("relativeY", 0.5);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RelativeLocator relativeLocator = (RelativeLocator)object;
        if (this.relativeX != relativeLocator.relativeX) {
            return false;
        }
        return this.relativeY == relativeLocator.relativeY;
    }

    public int hashCode() {
        int n = 7;
        n = 71 * n + (int)(Double.doubleToLongBits(this.relativeX) ^ Double.doubleToLongBits(this.relativeX) >>> 32);
        n = 71 * n + (int)(Double.doubleToLongBits(this.relativeY) ^ Double.doubleToLongBits(this.relativeY) >>> 32);
        return n;
    }
}

