#! /bin/bash

# Create a file "notify" next to "read-permissions" and ensure
# its contents are in the same format as "read-permissions",
# except that the values for allow and deny must be real email
# addresses. Install the corresponding .lua file in monotone.
#
# Call this script from cron or similar to process files
# generated by the .lua file.
#
# Copyright (c) 2007, Matthew Sackman (matthew at wellquite dot org)
#                     LShift Ltd (http://www.lshift.net)
# License: GPLv2 or later

DB="/path/to/a/private/unused/db.mtn"
MTN="/usr/bin/mtn"
SERVER="localhost"
HIGHLIGHT="/usr/bin/source-highlight"
MIMECONSTRUCT="/usr/bin/mime-construct"
BASE="/tmp/notify"

function processFile() {
    local fileBase=$1

    local hdr="$fileBase.hdr.txt"
    local rev="$fileBase.rev.txt"
    if [ ! -f $hdr ]
    then
	echo "Specified header file '$hdr' does not exist"
	exit 1
    fi

    if [ ! -f $rev ]
    then
	echo "Specified revision file '$hdr' does not exist"
	exit 1
    fi

    local revision=$(cat $rev | grep '^revision:' | sed -e 's/^revision:[ ]\+//')

    local parts=()
    local files=()
    let fIdx=0
    let pIdx=0
    local parents=$($MTN --reallyquiet -d $DB automate parents $revision)
    if [ "x" = "x$parents" ]
    then
	local plainDiff="$revision.noparent.diff"
	local htmlDiff="$revision.noparent.html"
	local partFile="$revision.noparent.part"
	files[0]=$plainDiff
	files[1]=$htmlDiff
	parts[0]=$partFile
	$MTN --reallyquiet -d $DB log --diffs --brief --no-graph --from $revision --to $revision > $plainDiff
	cat $plainDiff | $HIGHLIGHT -s diff -f html > $htmlDiff
	$MIMECONSTRUCT --subpart --multipart multipart/alternative \
	    --type text/plain --part-header "Content-Type: text/plain" --encoding quoted-printable --file $plainDiff \
	    --type text/html --encoding quoted-printable --file $htmlDiff \
	    > $partFile
    else
	for p in $parents
	do
	  local plainDiff="$revision.$p.diff"
	  local htmlDiff="$revision.$p.html"
	  local partFile="$revision.$p.part"
	  files[$fIdx]=$plainDiff
	  files[$fIdx+1]=$htmlDiff
	  let fIdx+=2
	  $MTN --reallyquiet -d $DB diff -r $p -r $revision > $plainDiff
	  cat $plainDiff | $HIGHLIGHT -s diff -f html > $htmlDiff
	  $MIMECONSTRUCT --subpart --multipart multipart/alternative \
	      --type text/plain --part-header "Content-Type: text/plain" --encoding quoted-printable --file $plainDiff \
	      --type text/html --encoding quoted-printable --file $htmlDiff \
	      > $partFile
	  parts[$pIdx]=$partFile
	  let pIdx+=1
	done
    fi

    local margs=""
    for p in ${parts[@]}
    do
      margs="$margs --subpart-file $p"
    done

    local hdrargs=$(cat $hdr)
    $MIMECONSTRUCT --embedded-to --header "$hdrargs" --multipart multipart/mixed \
	--type text/plain --part-header "Content-Type: text/plain" --encoding quoted-printable --file $rev \
	$margs

    for p in ${parts[@]}
    do
      rm $p
    done

    for f in ${files[@]}
    do
      rm $f
    done

    rm $hdr
    rm $rev
}

if [ "x" = "x$(ls $BASE)" ]
then
    exit 0
fi

$MTN --reallyquiet -d $DB pull $SERVER '*'

cwd=$(pwd)
cd $BASE

for f in $(ls $BASE | grep '.hdr.txt$')
do
  name=$(basename "$f" '.hdr.txt')
  processFile "$BASE/$name"
done

cd "$cwd"
