# copyright (C) 1997-2001 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: myprocs.tcl,v 2.6 2001/01/27 15:08:19 jfontain Exp $}


package provide myprocs [lindex {$Revision: 2.6 $} 1]
if {[lsearch -exact $auto_path /usr/lib]<0} {                         ;# in case Tcl/Tk is somewhere else than in the /usr hierarchy
    lappend auto_path /usr/lib
}
if {[catch {package require Mytcl} message]} {
    error "$message\nMytcl package does not seem to be installed:\nget it at http://jfontain.free.fr/"
}
package require miscellaneous 1


namespace eval myprocs {

    array set data {
        updates 0
        0,label id 0,type integer 0,message {process identifier}
        1,label user 1,type dictionary 1,message {user name}
        2,label host 2,type dictionary 2,message {host name}
        3,label database 3,type dictionary 3,message {database name}
        4,label command 4,type ascii 4,message command
        5,label time 5,type dictionary 5,message {process time in d(ays), h(ours), m(inutes) and s(econds)}
        6,label state 6,type dictionary 6,message state
        7,label information 7,type dictionary 7,message {query information} 7,anchor left
        sort {0 decreasing}
        pollTimes {10 5 20 30 60 120 300}
        switches {--host 1 --password 1 --port 1 --user 1}
    }
    set file [open myprocs.htm]
    set data(helpText) [read $file]                                                           ;# initialize HTML help data from file
    close $file

    proc initialize {optionsName} {
        upvar $optionsName options
        variable host
        variable user
        variable connection
        variable data

        set arguments {}
        set host localhost                                                                                             ;# by default
        catch {set host $options(--host)}
        lappend arguments $host
        set user $::env(USER)                                                                                          ;# by default
        catch {set user $options(--user)}
        lappend arguments $user
        set password {}
        catch {set password $options(--password)}
        catch {lappend arguments $password}
        lappend arguments {}                                                                              ;# no preselected database
        set port 3306                                                                                                  ;# by default
        catch {set port $options(--port)}
        catch {lappend arguments $port}
        set data(identifier) myprocs($host)
        set connection [eval sql connect $arguments]
        sql endquery $connection [sql query $connection {show processlist}]       ;# first check that user has the process privilege
    }

    proc update {} {
        variable connection
        variable data

        array unset data {[0-9]*,[0-9]*}                                      ;# refresh data every time since processes come and go
        if {[catch {set query [sql query $connection {show processlist}]} message]} {                     ;# problem reaching server
            flashMessage "myprocs error: $message"
        } else {
            while {[llength [set list [sql fetchrow $connection $query]]]>0} {
                set row [lindex $list 0]                                                                              ;# id (unique)
                set column 0
                foreach value $list {
                    if {($column==5)&&([string length $value]>0)} {    ;# time column (value may be empty when user connecting, ...)
                        set data($row,$column) [formattedTime $value]
                    } else {
                        set data($row,$column) $value
                    }
                    incr column
                }
            }
            sql endquery $connection $query
        }
        incr data(updates)
    }

    proc terminate {} {
        variable connection
        catch {sql disconnect $connection}
    }

}
