# copyright (C) 1997-2001 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: mystatus.tcl,v 2.15 2001/02/15 20:46:10 jfontain Exp $}


package provide mystatus [lindex {$Revision: 2.15 $} 1]
if {[lsearch -exact $auto_path /usr/lib]<0} {                         ;# in case Tcl/Tk is somewhere else than in the /usr hierarchy
    lappend auto_path /usr/lib
}
if {[catch {package require Mytcl} message]} {
    error "$message\nMytcl package does not seem to be installed:\nget it at http://jfontain.free.fr/"
}
package require miscellaneous 1


namespace eval mystatus {

    array set data {
        updates 0
        0,label display 0,type ascii 0,message \
{per second values are calculated for the last
poll period using the absolute values from the
server, and only for variables that make sense
(otherwise a ? is displayed in the column)}
        0,0 absolute 1,0 {per second}
        pollTimes {10 5 20 30 60 120 300}
        switches {--host 1 --password 1 --port 1 --user 1}
    }
    set file [open mystatus.htm]
    set data(helpText) [read $file]                                                           ;# initialize HTML help data from file
    close $file

    proc initialize {optionsName} {
        upvar $optionsName options
        variable host
        variable user
        variable connection
        variable data

        set arguments {}
        set host localhost                                                                                             ;# by default
        catch {set host $options(--host)}
        lappend arguments $host
        set user $::env(USER)                                                                                          ;# by default
        catch {set user $options(--user)}
        lappend arguments $user
        set password {}
        catch {set password $options(--password)}
        catch {lappend arguments $password}
        lappend arguments {}                                                                              ;# no preselected database
        set port 3306                                                                                                  ;# by default
        catch {set port $options(--port)}
        catch {lappend arguments $port}
        set data(identifier) mystatus($host)
        set connection [eval sql connect $arguments]
        set query [sql query $connection {show variables like 'version'}]
        scan [lindex [sql fetchrow $connection $query] 1] %u.%u.%u major minor subMinor
        sql endquery $connection $query
        if {$major<3} {
            error {cannot monitor a server below version 3}
        }
        if {$minor<22} {
            error {cannot monitor a server below version 3.22}
        }
        if {$minor>23} {
            error {cannot monitor a server above version 3.23}
        }
        if {$minor==23} {
            if {$subMinor<33} {
                error {cannot monitor a server below version 3.23.33 in the 3.23 series}
            }
            array set data {
                1,label {aborted clients} 1,type real 1,message
                "number of connections that have been\naborted because the client has died\nwithout closing the connection properly"
                2,label {aborted connects} 2,type real 2,message "number of tries to connect\nto the server that have failed"
                3,label <kilobytes 3,type real 3,message {number of kilobytes received}
                4,label kilobytes> 4,type real 4,message {number of kilobytes sent}
                5,label connections 5,type real 5,message {number of connection attempts to the server}
                6,label {disk temporaries} 6,type real 6,message
                    "number of implicit temporary tables on disk that\nhave been created while executing statements"
                7,label {memory temporaries} 7,type real 7,message
                    "number of implicit temporary tables in memory that\nhave been created while executing statements"
                8,label {temporary files} 8,type real 8,message {number of temporary files created by the server}
                9,label {delayed inserts} 9,type real 9,message {number of delayed insert handler threads in use}
                10,label {delayed writes} 10,type real 10,message {number of rows written with INSERT DELAYED}
                11,label {delayed errors} 11,type real 11,message
                    "number of rows written with\nINSERT DELAYED for which some error\noccurred (probably duplicate key)"
                12,label flush 12,type real 12,message {number of executed FLUSH commands}
                13,label delete 13,type real 13,message {number of times a row was deleted from a table}
                14,label {read first} 14,type real 14,message \
{number of times the first entry was read from an index.
If this is high, it suggests that the server is doing
a lot of full index scans, for example,
SELECT col1 FROM foo, assuming that col1 is indexed}
                15,label {read key} 15,type real 15,message \
{number of requests to read a row based on a key.
If this is high, it is a good indication that your
queries and tables are properly indexed}
                16,label {read order} 16,type real 16,message \
{number of requests to read next row in key order.
This will be incremented if you are querying an
index column with a range contraint. This also
will be incremented if you are doing an index scan}
                17,label {read previous} 17,type real 17,message
                    {number of requests to read previous row in key order (undocumented)}
                18,label {read fixed} 18,type real 18,message \
{number of requests to read a row based on a fixed position.
This will be high if you are doing a lot of queries that
require sorting of the result}
                19,label {read next} 19,type real 19,message \
{number of requests to read the next row in the datafile.
This will be high if you are doing a lot of table scans.
Generally this suggests that you tables are not properly
indexed or that you queries are not written to take
advantage of the indices you have}
                20,label updates 20,type real 20,message {number of requests to update a row in a table}
                21,label inserts 21,type real 21,message {number of requests to insert a row in a table}
                22,label blocks 22,type integer 22,message {number of used blocks in the key cache} 1,22 ?
                23,label <cache 23,type real 23,message {number of requests to read a key block from cache}
                24,label <disk 24,type real 24,message {number of physical reads of a key block from disk}
                25,label cache> 25,type real 25,message {number of requests to write a key block to cache}
                26,label disk> 26,type real 26,message {number of physical writes of a key block to disk}
                27,label connections 27,type integer
                    27,message "maximum number of connections that\nhave been in use simultaneously" 1,27 ?
                28,label {unflushed keys} 28,type integer
                    28,message "keys blocks in the key cache that have\nchanged but have not yet been flushed to disk" 1,28 ?
                29,label {unflushed rows} 29,type integer 29,message {number of rows waiting to be written in INSERT DELAY queues}
                    1,29 ?
                30,label {open tables} 30,type integer 30,message {number of tables that are open} 1,30 ?
                31,label files 31,type integer 31,message {number of files that are open} 1,31 ?
                32,label streams 32,type integer 32,message "number of streams that are open\n(used mainly for logging)" 1,32 ?
                33,label {opened tables} 33,type integer 33,message {number of tables that have been opened} 1,33 ?
                34,label queries 34,type real 34,message {number of queries sent to the server}
                35,label {select full join} 35,type integer 35,message {number of joins without keys (should be 0)} 1,35 ?
                36,label {select full range join} 36,type integer
                    36,message "number of joins where we used a\nrange search on reference table" 1,36 ?
                37,label {select range} 37,type integer 37,message
                    "number of joins where we used ranges on the first table\n(it is normally not critical even if this is big)"
                    1,37 ?
                38,label {select range check} 38,type integer
                    38,message "number of joins without keys where we check\nfor key usage after each row (should be 0)" 1,38 ?
                39,label {select scan} 39,type integer 39,message {number of joins where we scanned the first table} 1,39 ?
                40,label {slave running} 40,type ascii 40,message {whether the slave thread is running} 1,40 {}
                41,label {slave temporaries} 41,type integer
                    41,message "number of temporary tables currently\nopen by the slave thread" 1,41 {}
                42,label {slow threads} 42,type real 42,message
                    "number of threads that have taken more\nthan slow_launch_time to connect"
                43,label {slow queries} 43,type real 43,message "number of queries that have taken\nmore than long_query_time"
                44,label {sort merges} 44,type integer 44,message
                    "number of merges the sort has to do.\nIf this value is large you should\nconsider increasing sort_buffer"
                    1,44 ?
                45,label {sort range} 45,type integer 45,message {number of sorts that where done with ranges} 1,45 ?
                46,label {sort rows} 46,type integer 46,message {number of sorted rows} 1,46 ?
                47,label {sort scan} 47,type integer 47,message {number of sorts that where done by scanning the table} 1,47 ?
                48,label {locks immediate} 48,type integer 48,message {number of times a table lock was acquired immediately} 1,48 ?
                49,label {locks waited} 49,type integer 1,49 ? 49,message \
{number of times a table lock could not be acquired immediately
and a wait was needed. If this is high, and you have performance
problems, you should first optimize your queries, and then either
 split your table(s) or use replication.}
                50,label {cached threads} 50,type integer 50,message {number of threads in the thread cache} 1,50 ?
                51,label {created threads} 51,type integer 51,message {number of threads created to handle connections} 1,51 ?
                52,label {connected threads} 52,type integer 52,message {number of currently open connections} 1,52 ?
                53,label {running threads} 53,type integer 53,message {number of threads that are not sleeping} 1,53 ?
                54,label uptime 54,type dictionary
                    54,message "time the server has been up in\nd(ays), h(ours), m(inutes) and s(econds)" 1,54 {}
            }
            set data(views) {
                {
                    indices
                    {
                        0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29
                        30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54
                    }
                    swap 1
                }
            }
        } else {
            array set data {
                1,label {aborted clients} 1,type real 1,message
                "number of connections that have been\naborted because the client has died\nwithout closing the connection properly"
                2,label {aborted connects} 2,type real 2,message "number of tries to connect\nto the server that have failed"
                3,label temporary 3,type real 3,message
                    "number of implicit temporary tables that have\nbeen created while executing statements"
                4,label {delayed inserts} 4,type real 4,message {number of delayed insert handler threads in use}
                5,label {delayed writes} 5,type real 5,message {number of rows written with INSERT DELAYED}
                6,label {delayed errors} 6,type real 6,message
                    "number of rows written with\nINSERT DELAYED for which some error\noccurred (probably duplicate key)"
                7,label flush 7,type real 7,message {number of executed FLUSH commands}
                8,label delete 8,type real 8,message {number of requests to delete a row from a table}
                9,label {read first} 9,type real 9,message {number of requests to read the first row in a table}
                10,label {read key} 10,type real 10,message {number of requests to read a row based on a key}
                11,label {read next} 11,type real 11,message {number of requests to read next row in key order}
                12,label {read fixed} 12,type real 12,message {number of requests to read a row based on a fixed position}
                13,label updates 13,type real 13,message {number of requests to update a row in a table}
                14,label inserts 14,type real 14,message {number of requests to insert a row in a table}
                15,label blocks 15,type integer 15,message {number of used blocks in the key cache} 1,15 ?
                16,label <cache 16,type real 16,message {number of requests to read a key block from cache}
                17,label <disk 17,type real 17,message {number of physical reads of a key block from disk}
                18,label cache> 18,type real 18,message {number of requests to write a key block to cache}
                19,label disk> 19,type real 19,message {number of physical writes of a key block to disk}
                20,label connections 20,type integer
                    20,message "maximum number of connections\nthat have been in use simultaneously" 1,20 ?
                21,label {unflushed keys} 21,type integer
                    21,message "keys blocks in the key cache that have\nchanged but have not yet been flushed to disk" 1,21 ?
                22,label {unflushed rows} 22,type integer
                    22,message {number of rows waiting to be written in INSERT DELAY queues} 1,22 ?
                23,label {open tables} 23,type integer 23,message {number of tables that are open} 1,23 ?
                24,label files 24,type integer 24,message {number of files that are open} 1,24 ?
                25,label streams 25,type integer 25,message "number of streams that are open\n(used mainly for logging)" 1,25 ?
                26,label {opened tables} 26,type integer 26,message {number of tables that have been opened} 1,26 ?
                27,label queries 27,type real 27,message {number of queries sent to the server}
                28,label running 28,type integer 28,message {number of threads that are not sleeping} 1,28 ?
                29,label slow 29,type real 29,message "number of queries that have taken\nmore than long_query_time"
                30,label uptime 30,type dictionary
                    30,message "time the server has been up\nin d(ays), h(ours), m(inutes) and s(econds)" 1,30 {}
            }
            set data(views) {
                {indices {0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30} swap 1}
            }
        }
    }

    proc update {} {
        variable connection
        variable last
        variable data

        if {[catch {set query [sql query $connection {show status}]} message]} {                          ;# problem reaching server
            flashMessage "mystatus error: $message"
            catch {unset last}
            foreach name [array names data *,label] {
                scan $name %u column
                if {$column==0} continue                                                                           ;# headers column
                set data(0,$column) ?
                if {[string equal $data($column,type) real]} {                                     ;# required for per second values
                    set data(1,$column) ?
                }
            }
        } else {
            set clock [expr {[clock clicks -milliseconds]/1000.0}]                                         ;# store clock in seconds
            catch {set period [expr {$clock-$last(clock)}]}
            set last(clock) $clock
            set column 1
            while {[llength [set list [sql fetchrow $connection $query]]]>0} {
                foreach {variable value} $list {}
                if {[string equal $variable Uptime]} {
                    set data(0,$column) [formattedTime $value]
                    set data(1,$column) {}
                } else {
                    if {[string equal $data($column,type) real]} {                                 ;# required for per second values
                        if {[string match *Bytes* $variable]} {                     ;# anything in bytes is transformed to kilobytes
                            append value .0                                                                      ;# convert to float
                            set value [expr {$value/1000.0}]
                            set data(0,$column) [format %.2f $value]
                        } else {
                            set data(0,$column) $value                               ;# display as is as it really may be an integer
                        }
                        if {[info exists period]} {
                            set data(1,$column) [format %.2f [expr {($value-$last($column))/$period}]]
                        } else {
                            set data(1,$column) ?
                        }
                        set last($column) $value
                    } else {
                        set data(0,$column) $value
                    }
                }
                incr column
            }
            sql endquery $connection $query
        }
        incr data(updates)
    }

    proc terminate {} {
        variable connection
        catch {sql disconnect $connection}
    }

}
