." $Id: Slider.man,v 1.2 2000/01/17 20:55:18 falk Exp $
." view with "tbl | nroff -man"
."
.TH "Slider" 3 "Nov 1999" "Version 1.0" ""
.SH NAME
Slider
.SH DESCRIPTION
Slider is a widget similar to the Motif XmScale widget.  It
allows the user to specify an input value by moving a slider.
Operation is very similar to a scrollbar, but the size of the
thumb does not change, and the slider always operates over its
full range.
.P
The key slider resources are: minimum value, maximum value, current
value, step size, input scale and orientation.
.P
In addition, input scaling is available for very small sliders.
This means that large cursor motions map to small changes in the
slider.  For example, theoretically that a slider with only one
pixel of motion (or no pixels of motion for that matter) can
still be controlled over its full range.  Input scaling is normally
performed automatically for sliders with less than 100 pixels of
motion, with the scale factor set such that the range of cursor
motion is 100 pixels.
.P
Callbacks are provided for continuous changes and operation complete.
.P
Scrollwheel mouse support is provided.

.SH CLASS
Core => Slider

Slider does not require any specific widget set, and may be combined with
any other widget set.

.SH RESOURCES

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Slider
Name	Class	Type	Default
font	Font	XFontStruct*	XtDefaultFont
minimum	Minimum	int	0
maximum	Maximum	int	100
value	Value	int	0
step	Step	int	(max-min)/10
step2	Step2	int	1
orientation	Orientation	XtOrientation	horizontal
showValue	ShowValue	Boolean	False
decimalPoints	DecimalPoints	short	0
inputScale	InputScale	short	100%
autoScale	AutoScale	Boolean	True
sliderStyle	SliderStyle	SliderStyle	Normal
thumbLength	ThumbLength	short	20

shadowWidth	ShadowWidth	short	1
topShadowContrast	TopShadowContrast	short	20
bottomShadowContrast	BottomShadowContrast	short	40
armShadowContrast	ArmShadowContrast	short	40
insensitiveContrast	InsensitiveContrast	short	33
beNiceToColormap	BeNiceToColormap	Boolean	False

dragCallback	DragCallback	XtCallbackList	NULL
valueChangedCallback	ValueChangedCallback	XtCallbackList	NULL
.TE
.ps +2

.LP
See the \fBCore\fP widget for more resources.

.SS Descriptions.

.TP
.I Minimum
Value represented by the slider when at the left/bottom.

.TP
.I Maximum
Value represented by the slider when at the right/top.

.TP
.I Value
Current value represented by the slider.

.TP
.I Step
Amount slider value changes for clicks in the background to the left
or right of the thumb, or use of PageUp/PageDown keys.

.TP
.I Step2
Amount slider value changes for the arrow keys or scrollwheel motion.

.TP
.I Orientation
One of XtorientVertical or XtorientHorizontal.

.TP
.I InputScale
This is the ratio, in percent, of pointer motion to thumb motion in
the slider.  With the default value of 100%, one pixel of motion in the
pointer results in one pixel of motion in the thumb.  Smaller values
of inputScale result in smaller slider changes for a given amount of
pointer motion.  This can be used to allow the user finer control of
the slider.  This is especially useful for small sliders with a limited
range of motion.

.TP
.I AutoScale
Boolean.  When true, the inputScale is set automatically for small sliders.

.TP
.I DragCallback
Callback function called continuously as the thumb is dragged.  Call_data
is the current slider value.  This callback is not called for arrow
keys or scrollwheel mouse.

.TP
.I ValueChangedCallback
Callback function called once after the slider value changes.  Call_data
is the new slider value.

.TP
.I ShadowWidth
Width of the decorative shadow border.

.TP
.I TopShadowContrast, BottomShadowContrast, ArmShadowContrast, InsensitiveContrast
Controls the appearance of the slider.

.TP
.I BeNiceToColormap
Boolean.  When true, Slider widget allocates fewer colors for itself.

.TP
.I Font
Not used at this time.

.TP
.I ShowValue
Not used at this time.

.TP
.I DecimalPoints
Not used at this time.



.SH FUNCTIONS

.TP
void XawSliderSetValue(Widget w, int value, Boolean callCallbacks)
Sets the slider value.

.SH PROGRAMMING NOTES

See sliderdemo.c for a small sample application.  Minimum and maximum
are set to the values represented by the extreme ends of slider motion.
AutoScale and inputScale are normally left to their default values.
.P
A valueChangedCallback procedure should be provided to accept the
slider value after every change.  If some sort of continuous update
is required during drag operations, a dragCallback procedure should
also be provided.  Both procedures accept the same argument, so both
may be specified as the same procedure.


.SH SUBCLASSING

The slider class contains the following class methods:
\fBdraw_border, draw_background, draw_thumb, move_thumb\fP
and \fBfocus_proc\fP.  These may be specified as
XtInheritDrawBorder, XtInheritDrawBackground, XtInheritDrawThumb,
XtInheritMoveThumb and XtInheritFocusProc.  See Slider.c under
"Overview" for a detailed description.


.SH BUGS

Does not accept keyboard input in Motif.  Use the Motif XmScale
widget instead.


.SH AUTHOR
Edward Falk <falk@falconer.vip.best.com>

.SH COPYRIGHT
Copyright  2000 by Edward A. Falk.  This widget may be used freely in any
software.  Source code is freely distributable provided that my name
is not removed from it.

The X Consortium, and any party obtaining a copy of these files from the X
Consortium, directly or indirectly, is granted, free of charge, a full and
unrestricted irrevocable, world-wide, paid up, royalty-free, nonexclusive
right and license to deal in this software and documentation files (the
"Software"), including without limitation the rights to use, copy, modify,
merge, publish, distribute, sublicense, and sell copies of the Software,
and to permit persons who receive copies from any such party to do so.


