/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gestures for Mozilla.
 *
 * The Initial Developer of the Original Code is Jens Bannmann.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Jens Bannmann <jens.b@web.de>
 *  Jochen <bugs@krickelkrackel.de>
 *  Neil <neil@parkwaycc.co.uk>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var obs = Components.classes["@mozilla.org/observer-service;1"]
          .getService(Components.interfaces.nsIObserverService);

var dE, dTitle, dLoc, dialogMode, acceptBtn, permBtn, actTemp, wType;
var gestureType, codeBox, wheelBtn, wheelDir, category;
var funcType, funcTree, allFuncs, jsMappingName, jsBox, kbBox, kbMappingName;
var startType, startCode, startName, startFunc, startCount, startCat;
var bmMappingName, bmTree, bmItem, bmOpenIn, bmRow1, bmRow2;
var curMapping = false;
var bmS = mgCommon.bmService;
var gs = mgCommon.getString;

function mgE(id) {
  return document.getElementById(id);
}

function initMain() {
  dE = document.documentElement;
  acceptBtn = dE._buttons.accept;
  permBtn = dE._buttons.extra2;
  permBtn.hidden = true;
  permBtn.id = "mozgestPermissionButton";
  permBtn.label = dE.getAttribute("permBtn");

  if (bmS.plEnabled) {
    if (mgCommon.appInfo.name == "Firefox")
      document.loadOverlay("chrome://browser/content/places/placesOverlay.xul", plObserver);
    if (mgCommon.appInfo.name == "SeaMonkey")
      document.loadOverlay("chrome://communicator/content/bookmarks/placesOverlay.xul", plObserver);
  }
  else
    initEditor();
}

var plObserver = {
  observe: function(subject, topic, data) {
    var ssS = Components.classes["@mozilla.org/content/style-sheet-service;1"]
              .getService(Components.interfaces.nsIStyleSheetService);

    var place = (mgCommon.appInfo.name == "SeaMonkey") ? "communicator" : "browser";
    var sheet0 = mgCommon.makeURI("chrome://" + place + "/content/places/places.css");
    var sheet1 = mgCommon.makeURI("chrome://" + place + "/skin/places/places.css");

    if (!ssS.sheetRegistered(sheet0, ssS.USER_SHEET)) {
      ssS.loadAndRegisterSheet(sheet0, ssS.USER_SHEET);

      try {
        ssS.loadAndRegisterSheet(sheet1, ssS.USER_SHEET);
      }
      catch (err) {}
    }

    var abf = PlacesUIUtils.allBookmarksFolderId;
    mgE("mozgestPlacesTree").setAttribute("place",
                             "place:queryType=1&excludeReadOnlyFolders=1&onlyBookmarked=1&folder=" + abf); //&excludeQueries=1
    mgE("mozgestPlacesTree").setAttribute("type", "places");
    initEditor();
  }
}

function initEditor() {
  gestureType = mgE("gestureType");
  codeBox = mgE("codeBox");
  wheelBtn = mgE("wheelBtn");
  wheelDir = mgE("wheelDir");
  category = mgE("category");
  funcType = mgE("funcType");
  funcTree = mgE("funcTree");
  jsMappingName = mgE("jsMappingName");
  bmMappingName = mgE("bmMappingName");
  kbMappingName = mgE("kbMappingName");
  jsBox = mgE("mozgestJsBox");
  kbBox = mgE("mozgestKbBox")
  bmOpenIn = mgE("bmOpenIn");
  bmRow1 = mgE("bmRow1");
  bmRow2 = mgE("bmRow2");
  bmItem = null;

  mgE("regcognizeButtonDeck").selectedIndex = (mgCommon.mouseService) ? 1 : 0;
  mgInitHandler.initNotification();

  // [0] == dialogMode (Edit, New or Import)
  // [1] == wType (browser, viewsource, etc.)
  // [2] == gesture code
  dialogMode = window.arguments[0][0];
  wType = window.arguments[0][1];
  curMapping = window.arguments[0][2];

  dTitle = gs(dialogMode + "MappingWindow") + " - " + dE.getAttribute("mg" + wType);
  document.title = dTitle;

  if (mgCommon.appInfo.name != "Firefox") {
    mgE("sidebarItem").hidden = true;
    mgE("cat6").hidden = false;
  }

  // fill function tree
  var funcTemp = allFuncs = new Array();

  mgDefaultSettings.defaultFunctions.init()
  funcTemp = mgDefaultSettings.defaultFunctions.getFunctions();

  for (win in funcTemp) {
    for (each in funcTemp[win]) {
      var cat = String(funcTemp[win][each]);
      allFuncs[each] = cat.charAt(cat.length-1);
    }
  }

  for (func in _mgMS.functions[wType])
    mgCommon.addTreeRow(mgE("trcat" + allFuncs[func]), new Array(func, gs(func)), func);

  for (var x = 0; x < category.firstChild.childNodes.length; x++) {
    var tCat = mgE("trcat" + x);
    tCat.parentNode.hidden = (tCat.childNodes.length) ? false : true;
  }

  // bookmark mappings
  if (wType != "browser" || dialogMode == "Import") {
    bmS.enabled = bmS.plEnabled = false;
    funcType._tabs.removeChild(funcType._tabs.lastChild);
  }

  if (bmS.enabled || bmS.plEnabled) {
    bmTree = (bmS.enabled) ? mgE("mozgestBookmarksTree") : mgE("mozgestPlacesTree");
    bmTree.removeAttribute("hidden");
    mgE("bmInfo").value = bmRow1.value = gs("chooseBM");
  }

  actTemp = _mgMS.actTemp;

  if (dialogMode == "Edit") {
    var cMapping = actTemp[wType][curMapping];
    startCode = curMapping;
    startName = cMapping.name;
    startFunc = cMapping.func;
    startCount = cMapping.count;
    startCat = cMapping.cat;
    category.selectedItem = mgE("cat" + cMapping.cat);
    startType = cMapping.type;
    setGestureType();

    funcType.selectedTab = funcType.getElementsByAttribute("gestureType",
                               startType.charAt(0))[0];

    if (startType == "0")
      selectTreeItem(cMapping.cat, cMapping.func);
    else if (startType == "1") {
      jsMappingName.value = decodeURIComponent(cMapping.name);
      jsBox.value = decodeURIComponent(cMapping.func);
    }
    else if (startType == "2") {
      kbMappingName.value = decodeURIComponent(cMapping.name);
      kbBox.value = cMapping.func;
    }
    else if (startType.charAt(0) == "9") {
      bmMappingName.value = decodeURIComponent(cMapping.name);
      bmItem = cMapping.func;
      bmOpenIn.selectedIndex = startType.charAt(1);

      if (mgCommon.appInfo.name != "Firefox" && bmOpenIn.selectedIndex == 4)
        bmOpenIn.selectedIndex = 0;

      bmTreeSelect(null);
    }
  }

  if (dialogMode == "Import") {
    permBtn.hidden = false;
    funcType._tabs.lastChild.hidden = funcType._tabs.firstChild.hidden = true;
    setGestureType();

    dLoc = mgCommon.makeURI(_mgMS.importLocation);
    obs.addObserver(mgPermissionObserver, "mozgestControl", false);
    checkPermissions();

    jsMappingName.value = _mgMS.importName;
    category.selectedItem = mgE(_mgMS.importCat);
    jsBox.value = _mgMS.importCustom;
    funcType.selectedIndex = 1;
  }
}

function setGestureType() {
  if (curMapping.charAt(0) == ":") {
    var a = curMapping.charAt(1);
    var b = curMapping.charAt(2);

    if (!isNaN(b)) {
      gestureType.selectedIndex = 1;
      mgE("rocker1").selectedIndex = parseInt(a)+1;
      mgE("rocker2").selectedIndex = parseInt(b)+1;
    }
    else {
      gestureType.selectedIndex = 2;
      wheelBtn.selectedIndex = parseInt(a)+1;
      wheelDir.selectedIndex = (b == "+") ? 1 : 0;
    }
  }
  else
    codeBox.value = mgCommon.mappingLocalizer.localize(curMapping);
}

function updateCategory(aIndex) {
  if (!category)
    return;

  category.disabled = (aIndex == 0) ? true : false;
}

function updateSecondRocker(r1) {
  var r2 = mgE("rocker2");
  var c = r2.menupopup.childNodes;

  for (var i=1; i < c.length; i++) {
    c[i].removeAttribute("disabled");

    if (r1.selectedIndex == i)
      c[i].setAttribute("disabled", true);
  }

  if (r1.selectedIndex == r2.selectedIndex && r2.selectedIndex != 0)
    r2.selectedIndex = 0;
}

function selectTreeItem(aCat, aFunc) {
  mgE("trItemcat" + aCat).setAttribute("open", true);

  var item = mgE(aFunc);
  funcTree.view.selection.select(funcTree.view.getIndexOfItem(item));
  funcTree.boxObject.ensureRowIsVisible(funcTree.view.getIndexOfItem(item));
  funcTree.focus();
}

function setTreeSel(tree) {
  var sel = tree.view.selection;
  var index = sel.currentIndex;
  var tc = tree.view.getItemAtIndex(index)

  var cat = (tc.id.indexOf('tr') == 0) ? tc.id : tc.parentNode.id;
  cat = cat.substring(cat.length-1);
  category.selectedItem = mgE("cat" + cat);

  if (sel.isSelected(index) && tree.view.isContainer(index))
    sel.clearRange(index, index);

  index = sel.currentIndex;
  tc = tree.view.getItemAtIndex(index);
  return tc;
}

function bmTreeSelect(e) {
  if (e) {
    if (e.type == "dblclick") {
      if (!bmOpenIn.disabled)
        bmMappingName.value = mgE("bmInfo").value;

      return;
    }

    var bmItemPrev = bmItem;
    bmItem = null;
    var result = null;

    if (bmS.enabled) {
      var elt = bmTree.view.getResourceAtIndex(e.target.currentIndex)
                           .QueryInterface(Components.interfaces.nsIRDFNode).Value;

      result = bmS.bmInfo.getBMInfo(elt, true);

      if (bmS.bmInfo.isBookmark && !bmS.bmInfo.isLive) {
        try {
          var eltParent = bmTree.view.getResourceAtIndex(bmTree.view.getParentIndex(e.target.currentIndex))
                          .QueryInterface(Components.interfaces.nsIRDFNode).Value;

          bmS.bmInfo.getBMInfo(eltParent, true);
        }
        catch (e) {}

        if (!bmS.bmInfo.isLive)
          bmItem = elt;
      }
    }
    else if (bmS.plEnabled) {
      var target = bmTree.selectedNode;

      if (!target) {
        if (bmItemPrev)
          bmItem = bmItemPrev;

        return;
      }

      if (target.type == 0) {
        try {
          bmItem = bmS.plBook.getItemGUID(target.itemId);
        }
        catch (e) {}
      }
    }
  }

  setBmInfo(null);

  if (!bmItem)
    return;

  bmS.bmInfo.getBMInfo(bmItem, true);
  setBmInfo(bmS.bmInfo.uri, bmS.bmInfo.icon, bmS.bmInfo.title);
}

function setBmInfo(bmHref, icon, title) {
  if (!bmHref) {
    bmRow2.hidden = true;
    mgE("bmInfo").value = bmRow1.value = gs("chooseBM");
    mgE("bmImage").src = "chrome://mozgest/skin/attention.png";
    bmOpenIn.disabled = true;
    return;
  }

  if (bmHref) {
    mgE("bmImage").src = icon;
    mgE("bmInfo").value = title;
    bmOpenIn.disabled = false;
    var mC = bmOpenIn.menupopup.childNodes;

    for (var i = 0; i < mC.length; i++)
      mC[i].removeAttribute("disabled");

    if (bmHref.scheme == "javascript") {
      for (i = 1; i < mC.length; i++)
        mC[i].setAttribute("disabled", true);

      bmOpenIn.selectedIndex = 0;
      bmRow1.value = gs("bmBookmarklet");
    }
    else if (bmHref.spec.indexOf("%s") != -1)
      bmRow1.value = gs("bmSearch");
    else
      bmRow1.value = gs("bmBookmark");

     bmRow1.value = gs("bmType") + bmRow1.value;
     bmRow2.value = gs("bmHref") + bmHref.spec;
     bmRow2.hidden = false;
   }
   return;
}

function openPermWindow() {
  openDialog('chrome://mozgest/content/pref/permissions.xul','',
             'centerscreen,chrome,resizable,dependent', 'misc.importFrom', dLoc.host);
}

function checkPermissions() {
  var allow = (dLoc.scheme == "file") ? true : false;

  if (!allow) {
    var allowed = mgPrefs.prefs.getCharPref("misc.importFrom").split("|");

    for (var x = 0; x < allowed.length; x++) {
      if (allowed[x] == dLoc.host) {
        allow = true;
        break;
      }
    }
  }

  acceptBtn.disabled = allow ? false : true;

  if (allow) {
    permBtn.removeAttribute("mozgestNoImport");
    permBtn.setAttribute("tooltiptext", gs("permButtonLabel0"));
  }
  else {
    permBtn.setAttribute("mozgestNoImport", true);
    permBtn.setAttribute("tooltiptext", gs("permButtonLabel1"));
  }
}

var mgPermissionObserver = {
  observe: function(subject, topic, data) {
    if (data == "mozgestPermissionsChanged")
      checkPermissions();
  }
}

function removeObserver() {
  try {
    obs.removeObserver(mgPermissionObserver, "mozgestControl");
  }
  catch (e) {}

  try {
    mgObserver.unregister();
  }
  catch (e) {}

  try {
    window.opener.focus();
  }
  catch (e) {}
}

function fillKbBox(e) {
  e.preventDefault();
  e.stopPropagation();

  kbBox.value = e.ctrlKey + "|" + e.altKey + "|" + e.shiftKey + "|" +
                 e.metaKey + "|" + e.keyCode + "|" + e.charCode;
}

function mgA(msg) {
  mgCommon.prompt.alert(window, document.title, msg)
}

function saveMapping() {
  var code = mgCommon.mappingLocalizer.deLocalize(codeBox.value);

  if (gestureType.selectedIndex == 0) {
    if (code.charAt(0) == "*") {
      if (code.length < 3 || code.length > 4) {
        mgA(gs("enterGesture"));
        return false;
      }
    }

    if (!code.match(/^\*{0,1}[1379DLUR]+$/) || mgCommon.compactCode(code) != code) {
      mgA(gs("enterGesture"));
      return false;
    }
  }
  else if (gestureType.selectedIndex == 1) {
    var a = mgE("rocker1").selectedIndex -1;
    var b = mgE("rocker2").selectedIndex -1;

    if (a == -1 || b == -1) {
      mgA(gs("chooseRockerButtons"));
      return false;
    }
    code = ":" + a + b;
  }
  else if (gestureType.selectedIndex == 2) {
    var wb = wheelBtn.selectedIndex -1;
    var wd = wheelDir.selectedIndex;

    if (wd == -1 || wb == -1) {
      mgA(gs("chooseWheelDirBtn"));
      return false;
    }
    code = ":" + wb + ((wd == 1) ? "+" : "-");
  }

  var type  = funcType.selectedTab.getAttribute("gestureType");
  var name  = null;
  var func  = null;
  var count = 0;
  var cat   = category.selectedItem.id.charAt(3);

  if (type == "1") { // js
    name = jsMappingName.value;

    if (name == "") {
      mgA(gs("enterMappingName"));
      return false;
    }

    if (jsBox.value == "") {
      mgA(gs("chooseFunction"));
      return false;
    }

    name = encodeURIComponent(name);
    func = encodeURIComponent(jsBox.value);
  }
  else if (type == "2") { // keyboard
    name = kbMappingName.value;

    if (name == "") {
      mgA(gs("enterMappingName"));
      return false;
    }

    if (kbBox.value == "") {
      mgA(gs("enterKeyCode"));
      return false;
    }

    name = encodeURIComponent(name);
    func = kbBox.value;
  }
  else if (type == "9") { // bookmark
    name = bmMappingName.value;

    if (name == "") {
      mgA(gs("enterMappingName"));
      return false;
    }

    if (!bmItem || bmOpenIn.disabled) {
      mgA(gs("chooseBM"));
      return false;
    }

    name = encodeURIComponent(name);
    func = bmItem;
    type = type.toString() + bmOpenIn.selectedIndex.toString();
  }
  else { // built-in
    if (funcTree.view.selection.count < 1) {
      mgA(gs("chooseFunction"));
      return false;
    }

    var item = funcTree.contentView.getItemAtIndex(funcTree.contentView.selection.currentIndex);

    if (!item.id || !(item.id in allFuncs)) {
      mgA(gs("chooseFunction"));
      return false;
    }

    func = item.id;
    name = encodeURIComponent(gs(func));
    cat = allFuncs[func];
  }

  var conf = true;

  if (code in actTemp[wType] && code != startCode) {
    var msg = gs("overwriteWarning");
    msg = msg.replace(/%MAPPINGNAME%/, decodeURIComponent(actTemp[wType][code].name));
    msg = msg.replace(/%CODE%/, mgCommon.mappingLocalizer.localize(code));
    conf = mgCommon.prompt.confirm(window, document.title, msg);
  }

  if (conf) {
    if (dialogMode == "Edit") {
      // check if there were changes
      if (type != startType || code != startCode || name != startName ||
          func != startFunc || cat != startCat) {
        // if code was changed, remove the original gesture
        if (code != startCode) {
          //rebuild actTemp without startCode
          var temp = actTemp[wType];
          actTemp[wType] = new Array();

          for (mapping in temp) {
            if (mapping == startCode)
              continue;

            actTemp[wType][mapping] = temp[mapping];
          }
        }
        else
          count = startCount;
      }
      else
        return true;
    }

    // add mapping to actTemp
    _mgMS.addMappingToTemp(wType, code, type, name, func, count, cat);
  }

  return conf;
}

function cancelDialog() {
  if (mgE('contentDeck').selectedIndex == 1) {
    showRecognizer(false);
    return false;
  }

  return true;
}

// "embedding" gesture engine
var gestureEngineInit = false;

function showRecognizer(aBool) {
  mgWindowType = wType;
  mgWindowElements.statusPopup.hidePopup();
  acceptBtn.hidden = aBool;
  mgE('contentDeck').selectedIndex = (aBool) ? 1 : 0;
  document.title = (aBool) ? dE.getAttribute("titleRecognizer") : dTitle;

  if (aBool) {
    mgPrefs.enableStrokes = mgPrefs["trails.enabled"] = mgPrefs["status.isEnabled"] = true;
    mgPrefs.enableRockers = mgPrefs.enableWheelRockers = false;
    mgInitHandler.addWindowWatch();
  }
  else
    mgInitHandler.removeWindowWatch();

  if (gestureEngineInit)
    return;

  gestureEngineInit = true;
  mgInitHandler.loadStrings();
  mgObserver.register();
}

// We did not load gestures.js and windowTypes.js.
var mgWindowTypes = {
  getContentArea : function() {
    return mgE("gestureArea");
  },

  stopAutoScroll : function() {return false;}
}

var mgGestureExecute = {
  mgFireGesture : function(code){
    codeBox.value = mgCommon.mappingLocalizer.localize(code);
    showRecognizer(false);
    return;
  },

  mgCheckForRocker : function(e) {return false;},
  mgFireRocker : function(a, b) {},
  mgReleaseRocker : function(a) {},
  mgResetRocker : function(a) {},
  mgFireKeyEvent : function() {}
}