
/*
 * @(#)print.c 1.2 01/01/18
 *
 * Copyright (c) Rich Burridge. All rights reserved.
 *
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "mptool.h"

void
check_int_value(int *value, char *str,
                int minval, int maxval, int defval, gchar *label)
{
    char m[MAXLINE];

    *value = get_int_value(F_PRINT, label);
    if (*value < minval || *value > maxval) {
        SPRINTF(m, str, defval);
        notice(F_PRINT, m);
        *value = defval;
        set_int_value(F_PRINT, label, *value);
    }
}
