/***************************************************************************
                          addmp3.cpp  -  description
                             -------------------
    begin                : Sun Mar 4 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qfileinfo.h>

#include <kurlcompletion.h>
#include <kcompletionbox.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kconfig.h>
#include <kapp.h>

#include <iostream.h>

#include "addmp3.h"


AddMp3::AddMp3 (MyDb* db, QWidget* parent, const char* name)
     :QDialog (parent, name, TRUE), db(db)
{


     initDialog();
     initValue();

     connect (butfiledial, SIGNAL (clicked()), this, SLOT (slotbutfiledial()));
     connect (butok, SIGNAL(clicked()), SLOT (slotbutok()));
     connect (butcancel, SIGNAL(clicked()), SLOT (slotbutcancel()));
}

void AddMp3::initDialog()
{
     setCaption(i18n("Add Mp3"));

     QGridLayout* grid = new QGridLayout (this,3,3,8,14);

     QLabel *lvolname= new QLabel(i18n("Volume Name"), this);
     lvolname->resize( lvolname->sizeHint() );
     grid->addWidget(lvolname,0,0);

     volname = new QComboBox(this);
     grid->addMultiCellWidget(volname, 0, 0, 1, 2);

    lvolname->setBuddy (volname);

     grid->addRowSpacing (0, 40);
    /* QLabel *ldir= new QLabel(i18n("Directory"), this);
     ldir->resize( ldir->sizeHint() );
     grid->addWidget(ldir,2,0);            */

     QGroupBox* group = new QGroupBox (this);
     group->setTitle(i18n("Complete File Path"));
     group->setLineWidth(1);
     group->setMidLineWidth( 0 );
     grid->addMultiCellWidget(group, 1, 2, 0, 2);

     QGridLayout* grid1 = new QGridLayout (group, 1, 2, 15, 4);

     //mp3file = new QLineEdit(group);
	mp3file = new KComboBox(true, group);
     grid1->addWidget(mp3file, 0, 0);
     /*ldir->setBuddy (dir);*/
	mp3file->setFixedWidth (320);
	mp3file->completionBox()->setTabHandling( true );
	KURLCompletion *comp = new KURLCompletion(KURLCompletion::FileCompletion);
		mp3file->setCompletionObject( comp );
		connect( mp3file->completionBox(), SIGNAL( highlighted( const QString & )),
             mp3file, SLOT( setEditText ( const QString & )));

     butfiledial = new QPushButton (group, "Dir..." );
     butfiledial->setText ("...");
     //butfiledial->resize (butfiledial->sizeHint() );
		 butfiledial->setFixedWidth (30);
     grid1->addWidget (butfiledial, 0,1);
     /*connect (butdirdial, SIGNAL(clicked>()),*/

     butok = new QPushButton (this, "Push_Ok");
     butok->resize (butok->sizeHint() );
     butok->setText( i18n("Ok") );
     grid->addWidget (butok, 3,0);


     butcancel = new QPushButton( this, "Push_Cancel" );
     grid->addWidget(butcancel,3,2);
     butcancel->resize (butcancel->sizeHint() );
     butcancel->setText( i18n("Cancel") );


     volname->setFocus();
    // resize (320, 210);
		setFixedSize(400, 210);
}

void AddMp3::initValue()
{
     MYSQL_ROW row;

     //MyDb* db = new MyDb();

     db->getVolname();
     while ((row=db->getRow()))
          volname->insertItem(row[0]);
     db->freeRes();
		 KConfig* config;
		 config = kapp->config();

		 	config->setGroup("OPTIONS");
		 	lastDirs = config->readListEntry("LastDirs");
	if (!(lastDirs.isEmpty()))
	{
		for (uint i=0; i < lastDirs.count(); i++)
			mp3file->insertItem(lastDirs[i]);
		mp3file->setCurrentItem(-1);
	}

}

QString AddMp3::getFilePath()
{
     return (mp3file->currentText());
}

QString AddMp3::getVolName()
{
     return (volname->currentText());
}


void AddMp3::slotbutok()
{
	if (mp3file->currentText()=="")
	{
		done (1);
	}
	QFileInfo info (mp3file->currentText());

	if (!(info.isFile()) || !(info.isReadable()))
	{
		KMessageBox::sorry( this, i18n("This File \n"
                                      "doesn't exist or \n"
																			"is not readable !"));
       return;
     }

	 bool found = false;
	 for (uint i=0; i<lastDirs.count(); i++)
	 	if (lastDirs[i] == (info.dirPath(true)+"/"))
		{
			lastDirs.remove(lastDirs.at(i));
			lastDirs.prepend(info.dirPath(true)+"/");
			found = true;
			break;
		}
	if ( !found /*&& !(lastDirs.isEmpty())*/)
	{
		cerr << " NOT dupl" << endl;
		if ( lastDirs.count() > 9 )
			lastDirs.remove(lastDirs.last());
		lastDirs.prepend (info.dirPath(true)+"/");
	}

		KConfig* config;
		config = kapp->config();
			config->setGroup("OPTIONS");
			config->writeEntry("LastDirs", lastDirs );
		done(0);

}


void AddMp3::slotbutcancel()
{
    done(1);
}

void AddMp3::slotbutfiledial()
{
     QString file;
/*		 if (mp3file->currentText().isEmpty())
     file = KFileDialog::getOpenFileName(mp3file->currentText(),
                                         "*.mp3 *.Mp3 *.MP3 *.mP3|Mp3 File",
                                         this, i18n("Add Mp3..."));
	else
		file = KFileDialog::getOpenFileName(QDir::homeDirPath(),
                                         "*.mp3 *.Mp3 *.MP3 *.mP3|Mp3 File",
                                         this, i18n("Add Mp3..."));
*/

		file = KFileDialog::getOpenFileName(QDir::homeDirPath(),
                                         "*.mp3 *.ogg|All Supportes Files\n*.mp3|Mp3 Files\n*.ogg|Ogg Files",
                                         this, i18n("Add Mp3/Ogg..."));
mp3file->setEditText(file);
}

#include "addmp3.moc"
