/***************************************************************************
                          find.cpp  -  description
                             -------------------
    begin                : Mon Feb 19 2001
    copyright            : (C) 2001 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "find.h"
#include "resources.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qvaluelist.h>
//#include <qgroupbox.h>

#include <klocale.h>
#include <kdebug.h>
#include <kapp.h>
#include <kconfig.h>


Mp3Find::Mp3Find(QWidget* parent, const char* name )
     : QWidget(parent, name)
{
     initFindDialog();
    // initAdvSearch();

     connect (butok, SIGNAL(clicked()), this, SLOT (slotbutok()));
     connect (word, SIGNAL(returnPressed()), this, SLOT(slotbutok()));
     connect (advword, SIGNAL(returnPressed()), this, SLOT(slotbutok()));
     connect (butcancel, SIGNAL(clicked()), this, SLOT(slotbutcancel()));
}

void Mp3Find::initFindDialog()
{

     setCaption(i18n("Find"));
     QGridLayout* princ = new QGridLayout(this, 2 ,3, 8, 8);

     tabWidget = new QTabWidget(this);
     princ->addMultiCellWidget(tabWidget, 0, 0, 0, 2);

     /*QWidget**/ searchW = new QWidget(tabWidget);
     QGridLayout* searchL = new QGridLayout (searchW, 1, 1, 20, 15);

     QLabel* lword = new QLabel (i18n("Search for:"), searchW);
     lword->resize(lword->sizeHint());
     searchL->addWidget(lword, 0, 0);

     word = new QLineEdit(searchW);
     searchL->addWidget(word,0,1);
     lword->setBuddy(word);

     tabWidget->addTab(searchW, i18n("Base"));

     /*QWidget**/ advsearchW = new QWidget (this);
     QGridLayout* advsearchL = new QGridLayout (advsearchW, 5, 4, 8, 8);

     QLabel* ladvword = new QLabel (i18n("Search for:"), advsearchW);
     ladvword->resize(ladvword->sizeHint());
     advsearchL->addWidget (ladvword, 0, 0);

     advword = new QLineEdit(advsearchW);
     advsearchL->addMultiCellWidget(advword, 0, 0, 1 ,3);
     ladvword->setBuddy(advword);

     QButtonGroup* gSearchIn = new QButtonGroup(advsearchW);
     gSearchIn->setTitle(i18n("Search in"));
     QGridLayout* glayout = new QGridLayout(gSearchIn, 2, 4, 20, 8);

     cTitle = new QCheckBox (i18n("Title"), gSearchIn);
     gSearchIn->insert(cTitle, ID_TITLE);
     glayout->addWidget(cTitle, 2, 0);

     cArtist = new QCheckBox (i18n("Artist"), gSearchIn);
     gSearchIn->insert(cArtist, ID_ARTIST);
     glayout->addWidget(cArtist, 2, 1);

     cAlbum = new QCheckBox (i18n("Album"), gSearchIn);
     gSearchIn->insert(cAlbum, ID_ALBUM);
     glayout->addWidget(cAlbum, 2, 2);

     cGenre = new QCheckBox (i18n("Genre"), gSearchIn);
     gSearchIn->insert(cGenre, ID_GENRE);
     glayout->addWidget(cGenre, 2, 3);

    /* cYear = new QCheckBox (i18n("Year"), advsearchW);
     advsearchL->addWidget(cYear, 3, 0);  */

     cComment = new QCheckBox (i18n("Comment"), gSearchIn);
     gSearchIn->insert(cComment, ID_COMMENT);
     glayout->addWidget(cComment, 3, 0);

    /* cLength = new QCheckBox (i18n("Length"), advsearchW);
     advsearchL->addWidget(cLength, 3, 2); */

     cPath = new QCheckBox (i18n("Path"), gSearchIn);
     gSearchIn->insert(cPath, ID_PATH);
     glayout->addWidget(cPath, 3, 1);

     cFname = new QCheckBox (i18n("File Name"), gSearchIn);
     gSearchIn->insert(cFname, ID_FNAME);
     glayout->addWidget(cFname, 3, 2);

     cVolume = new QCheckBox (i18n("Volume"), gSearchIn);
     gSearchIn->insert(cVolume, ID_VOLUME);
     glayout->addWidget(cVolume, 3, 3);

    /* cSize = new QCheckBox (i18n("Size"), advsearchW);
     advsearchL->addWidget(cSize, 4, 2);  */
     advsearchL->addMultiCellWidget(gSearchIn, 2, 4, 0, 3);
     tabWidget->addTab(advsearchW, i18n("Advanced"));

     butok = new QPushButton (this, "Push_Ok");
     butok->resize( butok->sizeHint());
     butok->setText( i18n("Ok"));
     princ->addWidget(butok, 1, 0);

     butcancel = new QPushButton (this, "Push_Cancel");
     butcancel->resize(butcancel->sizeHint());
     butcancel->setText(i18n("Cancel"));
     princ->addWidget (butcancel, 1, 2);

     word->setFocus();
     advword->setFocus();

}

void Mp3Find::initAdvSearch()
{
    KConfig* config;
    config = kapp->config();

    config->setGroup("View");

    QValueList<int> lst;
    lst = config->readIntListEntry("ColumnsVis");
    if (lst.count()==NUMCOL)
     {
          QValueList<int>::Iterator it = lst.begin();
          for (int i= 0; i<NUMCOL; i++)
          {
               if (!(*it))
               {
                    disableItem(i);
               }
               ++it;
          }
     }
}

void Mp3Find::slotbutok()
{
    if ((tabWidget->currentPage()==searchW) && (word->text()!=""))
    {
     kdDebug() << "Start Base Search" << endl;
     hide();
     emit search(word->text(), TRUE);
     word->setSelection(0, (word->text()).length());
    }
    else if ((tabWidget->currentPage()==advsearchW) && (advword->text()!=""))
    {
     kdDebug() << "Start Advanced Search" << endl;
     hide();
     for (int i=0; i<SOPTIONS; i++)
          options[i]=FALSE;

     if (cTitle->isChecked())
          options[OP_TITLE]=TRUE;
     if (cArtist->isChecked())
          options[OP_ARTIST]=TRUE;
     if (cAlbum->isChecked())
          options[OP_ALBUM]=TRUE;
     if (cGenre->isChecked())
          options[OP_GENRE]=TRUE;
     if (cPath->isChecked())
          options[OP_PATH]=TRUE;
     if (cFname->isChecked())
          options[OP_FNAME]=TRUE;
     if (cVolume->isChecked())
          options[OP_VOLUME]=TRUE;
     if(cComment->isChecked())
          options[OP_COMMENT]=TRUE;

     emit advsearch(advword->text(), TRUE, options);
     advword->setSelection(0, (advword->text()).length());
     }
}

void Mp3Find::slotbutcancel()
{
     hide();
     word->setSelection(0, (word->text()).length());
     advword->setSelection(0, (advword->text()).length());
}

void Mp3Find::findnext()
{
     if (tabWidget->currentPage()==searchW)
          emit search(word->text(), FALSE);
     else if (tabWidget->currentPage()==advsearchW)
     {
          emit advsearch(advword->text(), FALSE, options);
     }
}

void Mp3Find::enableItem(int id)
{
    QCheckBox* item = (QCheckBox*)gSearchIn->find(id);
    if (item && !(item->isEnabled()))
    {
        item->setEnabled(true);
    }
}

void Mp3Find::disableItem(int id)
{
    QCheckBox* item = (QCheckBox*)gSearchIn->find(id);
    if (item && item->isEnabled())
    {
        item->setChecked(false);
        item->setEnabled(false);
    }
}

#include "find.moc"

