/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public final class StringContent
implements AbstractDocument.Content,
Serializable {
    private static final char[] empty = new char[0];
    private char[] data;
    private int count;
    transient Vector marks;

    public StringContent() {
        this(10);
    }

    public StringContent(int n) {
        if (n < 1) {
            n = 1;
        }
        this.data = new char[n];
        this.data[0] = 10;
        this.count = 1;
    }

    public Position createPosition(int n) throws BadLocationException {
        if (this.marks == null) {
            this.marks = new Vector();
        }
        return new StickyPosition(n);
    }

    public void getChars(int n, int n2, Segment segment) throws BadLocationException {
        if (n + n2 > this.count) {
            throw new BadLocationException("Invalid location", this.count);
        }
        segment.array = this.data;
        segment.offset = n;
        segment.count = n2;
    }

    protected Vector getPositionsInRange(Vector vector, int n, int n2) {
        int n3 = this.marks.size();
        int n4 = n + n2;
        Vector vector2 = vector == null ? new Vector() : vector;
        int n5 = 0;
        while (n5 < n3) {
            PosRec posRec = (PosRec)this.marks.elementAt(n5);
            if (posRec.unused) {
                this.marks.removeElementAt(n5);
                --n5;
                --n3;
            } else if (posRec.offset >= n && posRec.offset <= n4) {
                vector2.addElement(new UndoPosRef(posRec));
            }
            ++n5;
        }
        return vector2;
    }

    public String getString(int n, int n2) throws BadLocationException {
        if (n + n2 > this.count) {
            throw new BadLocationException("Invalid range", this.count);
        }
        return new String(this.data, n, n2);
    }

    public UndoableEdit insertString(int n, String string) throws BadLocationException {
        if (n >= this.count) {
            throw new BadLocationException("Invalid location", this.count);
        }
        char[] cArray = string.toCharArray();
        this.replace(n, 0, cArray, 0, cArray.length);
        if (this.marks != null) {
            this.updateMarksForInsert(n, string.length());
        }
        return new InsertUndo(n, string.length());
    }

    public int length() {
        return this.count;
    }

    public UndoableEdit remove(int n, int n2) throws BadLocationException {
        if (n + n2 >= this.count) {
            throw new BadLocationException("Invalid range", this.count);
        }
        String string = this.getString(n, n2);
        RemoveUndo removeUndo = new RemoveUndo(n, string);
        this.replace(n, n2, empty, 0, 0);
        if (this.marks != null) {
            this.updateMarksForRemove(n, n2);
        }
        return removeUndo;
    }

    void replace(int n, int n2, char[] cArray, int n3, int n4) {
        int n5 = n4 - n2;
        int n6 = n + n2;
        int n7 = this.count - n6;
        int n8 = n6 + n5;
        if (this.count + n5 >= this.data.length) {
            int n9 = Math.max(2 * this.data.length, this.count + n5);
            char[] cArray2 = new char[n9];
            System.arraycopy(this.data, 0, cArray2, 0, n);
            System.arraycopy(cArray, n3, cArray2, n, n4);
            System.arraycopy(this.data, n6, cArray2, n8, n7);
            this.data = cArray2;
        } else {
            System.arraycopy(this.data, n6, this.data, n8, n7);
            System.arraycopy(cArray, n3, this.data, n, n4);
        }
        this.count += n5;
    }

    void resize(int n) {
        char[] cArray = new char[n];
        System.arraycopy(this.data, 0, cArray, 0, Math.min(n, this.count));
        this.data = cArray;
    }

    synchronized void updateMarksForInsert(int n, int n2) {
        if (n == 0) {
            n = 1;
        }
        int n3 = this.marks.size();
        int n4 = 0;
        while (n4 < n3) {
            PosRec posRec = (PosRec)this.marks.elementAt(n4);
            if (posRec.unused) {
                this.marks.removeElementAt(n4);
                --n4;
                --n3;
            } else if (posRec.offset >= n) {
                posRec.offset += n2;
            }
            ++n4;
        }
    }

    synchronized void updateMarksForRemove(int n, int n2) {
        int n3 = this.marks.size();
        int n4 = 0;
        while (n4 < n3) {
            PosRec posRec = (PosRec)this.marks.elementAt(n4);
            if (posRec.unused) {
                this.marks.removeElementAt(n4);
                --n4;
                --n3;
            } else if (posRec.offset >= n + n2) {
                posRec.offset -= n2;
            } else if (posRec.offset >= n) {
                posRec.offset = n;
            }
            ++n4;
        }
    }

    protected void updateUndoPositions(Vector vector) {
        int n = vector.size() - 1;
        while (n >= 0) {
            UndoPosRef undoPosRef = (UndoPosRef)vector.elementAt(n);
            if (undoPosRef.rec.unused) {
                vector.removeElementAt(n);
            } else {
                undoPosRef.resetLocation();
            }
            --n;
        }
    }

    final class PosRec {
        int offset;
        boolean unused;

        PosRec(int n) {
            this.offset = n;
        }
    }

    final class StickyPosition
    implements Position {
        PosRec rec;

        StickyPosition(int n) {
            StringContent stringContent2 = StringContent.this;
            stringContent2.getClass();
            this.rec = stringContent2.new PosRec(n);
            StringContent.this.marks.addElement(this.rec);
        }

        protected void finalize() throws Throwable {
            this.rec.unused = true;
        }

        public int getOffset() {
            return this.rec.offset;
        }

        public String toString() {
            return Integer.toString(this.getOffset());
        }
    }

    final class UndoPosRef {
        protected int undoLocation;
        protected PosRec rec;

        UndoPosRef(PosRec posRec) {
            this.rec = posRec;
            this.undoLocation = posRec.offset;
        }

        protected void resetLocation() {
            this.rec.offset = this.undoLocation;
        }
    }

    class InsertUndo
    extends AbstractUndoableEdit {
        protected int offset;
        protected int length;
        protected String string;
        protected Vector posRefs;

        protected InsertUndo(int n, int n2) {
            this.offset = n;
            this.length = n2;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            try {
                StringContent stringContent = StringContent.this;
                synchronized (stringContent) {
                    StringContent.this.insertString(this.offset, this.string);
                    this.string = null;
                    if (this.posRefs != null) {
                        StringContent.this.updateUndoPositions(this.posRefs);
                        this.posRefs = null;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }

        public void undo() throws CannotUndoException {
            super.undo();
            try {
                StringContent stringContent = StringContent.this;
                synchronized (stringContent) {
                    if (StringContent.this.marks != null) {
                        this.posRefs = StringContent.this.getPositionsInRange(null, this.offset, this.length);
                    }
                    this.string = StringContent.this.getString(this.offset, this.length);
                    StringContent.this.remove(this.offset, this.length);
                }
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }
    }

    class RemoveUndo
    extends AbstractUndoableEdit {
        protected int offset;
        protected int length;
        protected String string;
        protected Vector posRefs;

        protected RemoveUndo(int n, String string) {
            this.offset = n;
            this.string = string;
            this.length = string.length();
            if (StringContent.this.marks != null) {
                this.posRefs = StringContent.this.getPositionsInRange(null, n, this.length);
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            try {
                StringContent stringContent = StringContent.this;
                synchronized (stringContent) {
                    this.string = StringContent.this.getString(this.offset, this.length);
                    if (StringContent.this.marks != null) {
                        this.posRefs = StringContent.this.getPositionsInRange(null, this.offset, this.length);
                    }
                    StringContent.this.remove(this.offset, this.length);
                }
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }

        public void undo() throws CannotUndoException {
            super.undo();
            try {
                StringContent stringContent = StringContent.this;
                synchronized (stringContent) {
                    StringContent.this.insertString(this.offset, this.string);
                    if (this.posRefs != null) {
                        StringContent.this.updateUndoPositions(this.posRefs);
                        this.posRefs = null;
                    }
                    this.string = null;
                }
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }
    }
}

