/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 CodeFactory AB
 * Copyright (C) 2001 Mikael Hallendal <micke@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Mikael Hallendal <micke@codefactory.se>
 */
/*
 * Modified by Thomas Nyberg <thomas@codefactory.se>
 */
#ifndef __FILTER_TABLE_MODEL_H__
#define __FILTER_TABLE_MODEL_H__

#include <glib.h>
#include <gal/e-table/e-table-model.h>
#include <gtk/gtktypeutils.h>
#include "libmrproject/GNOME_MrProject.h"

#define FILTER_TABLE_MODEL_TYPE        (filter_table_model_get_type ())
#define FILTER_TABLE_MODEL(o)          (GTK_CHECK_CAST ((o), FILTER_TABLE_MODEL_TYPE, FilterTableModel))
#define FILTER_TABLE_MODEL_CLASS(k)    (GTK_CHECK_CLASS_CAST ((k), FILTER_TABLE_MODEL_TYPE, FilterTableModelClass))
#define IS_FILTER_TABLE_MODEL(o)       (GTK_CHECK_TYPE ((o), FILTER_TABLE_MODEL_TYPE))
#define IS_FILTER_TABLE_MODEL_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), FILTER_TABLE_MODEL_TYPE))

enum {
	FT_COL_ID,
	FT_COL_ALLOCATED,
	FT_COL_NAME,
	LAST_FT_COL
};

typedef struct _FilterTableModel        FilterTableModel;
typedef struct _FilterTableModelClass   FilterTableModelClass;
typedef struct _FilterTableModelPriv    FilterTableModelPriv;

struct _FilterTableModel {
        ETableModel          parent;

        FilterTableModelPriv *priv;
};

struct _FilterTableModelClass {
        ETableModelClass     parent_class;
  
	void (*resource_allocated)       (FilterTableModel          *ftm,
					  GNOME_MrProject_Id        res_id);
	 
	void (*resource_deallocated)     (FilterTableModel          *ftm,
					  GNOME_MrProject_Id        res_id);
};

GtkType       filter_table_model_get_type (void);
ETableModel * filter_table_model_new      (void);

void  filter_table_model_add_resource     (FilterTableModel          *ftm,
					   GNOME_MrProject_Resource *res);
void  filter_table_model_update_resource  (FilterTableModel          *ftm,
					   GNOME_MrProject_Resource *res );
void  filter_table_model_remove_resource  (FilterTableModel          *ftm,
					   GNOME_MrProject_Id        res_id);

void  filter_table_model_set_allocation   (FilterTableModel          *ftm,
					   GNOME_MrProject_Id        res_id,
					   gboolean                  allocate);

#endif /* __FILTER_TABLE_MODEL_H__ */
