/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 Anders Carlsson <andersca@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Anders Carlsson
 */

#ifndef __NETWORK_COMPONENT_H__
#define __NETWORK_COMPONENT_H__

#include <gtk/gtktypeutils.h>
#include "client/components/shell-component/shell-component.h"

#define NETWORK_COMPONENT_TYPE        (network_component_get_type ())
#define NETWORK_COMPONENT(o)          (GTK_CHECK_CAST ((o), NETWORK_COMPONENT_TYPE, NetworkComponent))
#define NETWORK_COMPONENT_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), NETWORK_COMPONENT_TYPE, NetworkComponentClass))
#define IS_NETWORK_COMPONENT(o)       (GTK_CHECK_TYPE ((o), NETWORK_COMPONENT_TYPE))
#define IS_NETWORK_COMPONENT_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), NETWORK_COMPONENT_TYPE))

typedef struct _NetworkComponentPriv NetworkComponentPriv;

typedef struct {
	ShellComponent          parent;
	NetworkComponentPriv   *priv;
} NetworkComponent;

typedef struct {
	ShellComponentClass      parent_class;
} NetworkComponentClass;


GtkType  network_component_get_type  (void);


#endif /* _NETWORK_COMPONENT_H_ */

