/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 CodeFactory AB
 * Copyright (C) 2001 Mikael Hallendal <micke@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Mikael Hallendal <micke@codefactory.se>
 */

#ifndef __GROUP_DIALOG_H__
#define __GROUP_DIALOG_H__

#include <glib.h>
#include <gtk/gtktypeutils.h>
#include <gtk/gtkwidget.h>
#include <gtk/gtkwindow.h>
#include "libmrproject/GNOME_MrProject.h"
#include "util/corba-utils.h"

#define GROUP_DIALOG_TYPE         (group_dialog_get_type ())
#define GROUP_DIALOG(o)           (GTK_CHECK_CAST ((o), GROUP_DIALOG_TYPE, GroupDialog))
#define GROUP_DIALOG_CLASS(k)     (GTK_CHECK_CLASS_CAST ((k), GROUP_DIALOG_TYPE, GroupDialogClass))
#define IS_GROUP_DIALOG(o)        (GTK_CHECK_TYPE ((o), GROUP_DIALOG_TYPE))
#define IS_GROUP_DIALOG_CLASS(k)  (GTK_CHECK_CLASS_TYPE ((k), GROUP_DIALOG_TYPE))

typedef struct _GroupDialog      GroupDialog;
typedef struct _GroupDialogClass GroupDialogClass;
typedef struct _GroupDialogPriv  GroupDialogPriv;

struct _GroupDialog {
	GtkWindow        parent;

	GroupDialogPriv *priv;
};

struct _GroupDialogClass {
	GtkWindowClass   parent_class;

	/* Signals */
	void (*group_add)                  (void);
	void (*group_delete)               (gint                gid);
	void (*group_updated)              (GM_ResourceGroup   *group);
	void (*group_default_set)          (GM_Id               group_id);
	
};

GtkType     group_dialog_get_type          (void);
GtkWidget  *group_dialog_new               (GSList             *groups);

void        group_dialog_add_group         (GroupDialog        *dialog,
					    GM_ResourceGroup   *group);
void        group_dialog_remove_group      (GroupDialog        *dialog,
					    GM_Id               gid);
void        group_dialog_update_group      (GroupDialog        *dialog,
					    GM_ResourceGroup   *group);
void        group_dialog_set_default_group (GroupDialog        *dialog,
					    GM_Id               gid);


#endif /* __GROUP_DIALOG_H__ */
