/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2000 CodeFactory AB
 * Copyright (C) 2000 Richard Hult <rhult@codefactory.se>
 * Copyright (C) 2001 Mikael Hallendal <micke@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifndef __FILE_TASK_MODEL_H__
#define __FILE_TASK_MODEL_H__

#include <glib.h>
#include <gtk/gtkobject.h>
#include <gtk/gtktypeutils.h>
#include "libmrproject/GNOME_MrProject.h"
#include "util/corba-utils.h"
#include "project-engine/task-model.h"

#define TYPE_FILE_TASK_MODEL		(file_task_model_get_type ())
#define FILE_TASK_MODEL(obj)		(GTK_CHECK_CAST ((obj), TYPE_FILE_TASK_MODEL, FileTaskModel))
#define FILE_TASK_MODEL_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), TYPE_FILE_TASK_MODEL, FileTaskModelClass))
#define IS_FILE_TASK_MODEL(obj)	(GTK_CHECK_TYPE ((obj), TYPE_FILE_TASK_MODEL))
#define IS_FILE_TASK_MODEL_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((obj), TYPE_FILE_TASK_MODEL))

typedef struct _FileTaskModel FileTaskModel;
typedef struct _FileTaskModelClass FileTaskModelClass;
typedef struct _FileTaskModelPriv FileTaskModelPriv;

struct _FileTaskModel
{
	TaskModel	       parent;
	GNOME_MrProject_Task  *task;
	GNode                 *node;
	GSList                *predecessors;
	GSList                *successors;
};

struct _FileTaskModelClass
{
	TaskModelClass         parent_class;
};

GtkType	    file_task_model_get_type  (void);
TaskModel  *file_task_model_new       (const GNOME_MrProject_Task *task);


#endif /* __FILE_TASK_MODEL_H__ */

