/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 CodeFactory AB
 * Copyright (C) 2001 Richard Hult <rhult@codefactory.se>
 * Copyright (C) 2001 Mikael Hallendal <micke@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author:  Richard Hult <rhult@codefactory.se>
 */

#ifndef __ID_MAP_H__
#define __ID_MAP_H__

#include <gtk/gtktypeutils.h>
#include <gtk/gtkobject.h>
#include "libmrproject/GNOME_MrProject.h"

#define TYPE_ID_MAP		(id_map_get_type ())
#define ID_MAP(obj)		(GTK_CHECK_CAST ((obj), TYPE_ID_MAP, IdMap))
#define ID_MAP_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), TYPE_ID_MAP, IdMapClass))
#define IS_ID_MAP(obj)		(GTK_CHECK_TYPE ((obj), TYPE_ID_MAP))
#define IS_ID_MAP_CLASS(klass)  (GTK_CHECK_CLASS_TYPE ((obj), TYPE_ID_MAP))


typedef struct _IdMap       IdMap;
typedef struct _IdMapClass  IdMapClass;
typedef struct _IdMapPriv   IdMapPriv;

struct _IdMap
{
	GtkObject  parent;
	IdMapPriv *priv;
};

struct _IdMapClass
{
	GtkObjectClass parent_class;
};


GtkType             id_map_get_type     (void);
IdMap *             id_map_new          (GNOME_MrProject_Id    first_id);
GNOME_MrProject_Id  id_map_insert       (IdMap                *map, 
                                         gpointer              data);
gboolean            id_map_insert_id    (IdMap                *map, 
                                         GNOME_MrProject_Id    id, 
                                         gpointer              data);
gboolean            id_map_remove       (IdMap                *map, 
                                         GNOME_MrProject_Id    id);
gpointer            id_map_lookup       (IdMap                *map, 
                                         GNOME_MrProject_Id    id);
void                id_map_foreach      (IdMap                *map, 
                                         GHFunc                func, 
                                         gpointer              user_data);
gint                id_map_size         (IdMap                *map);
GSList *            id_map_get_keys     (IdMap                *map);
GSList *            id_map_get_objects  (IdMap                *map);

#endif /* __ID_MAP_H__ */
