/* Copyright (C) 1999 Beau Kuiper

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "ftpd.h"

extern int signumber;

int popcmd(FTPSTATE *peer, char **outstr)
{
	/* find the EOL marker (remember it is in ansi style!) */
	char *chtmp = strstr(STRTOCHAR(peer->inbuffer), "\r\n"); 
	*outstr = NULL;
	
	if (chtmp == NULL)
		return(FALSE);
	else
	{
		if ((chtmp - STRTOCHAR(peer->inbuffer)) != (STRLENGTH(peer->inbuffer) - 2))
		{
			/* they are breaking the RFC, kill them now! */
			return(TRUE);
		}	
		*chtmp = 0;
		*outstr = STRTOCHAR(peer->inbuffer);
		return(FALSE);
	}
}
	
int readcmd(FTPSTATE *peer)
{
	char inputbuf[BUFFERSIZE];
	int stringlen, oldlen = STRLENGTH(peer->inbuffer);
	
	stringlen = read(peer->remotefd, inputbuf, BUFFERSIZE);

	if (stringlen <= 0)
		return(TRUE);
	
	string_cat(&(peer->inbuffer), inputbuf, stringlen);
	string_filterbadchars(&(peer->inbuffer), oldlen);

	return(FALSE);	
}
