//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: meter.h,v 1.2 2001/11/20 15:19:33 muse Exp $
//
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __METER_H__
#define __METER_H__

#include <qframe.h>
#include <qpixmap.h>

class Meter : public QFrame {
      bool overflow;
      double val;
      double maxVal;
      double minScale, maxScale;
      int yellowScale, redScale;

      QPixmap bgPm;
      QPixmap fgPm;  // for double buffering

      Q_OBJECT
      virtual void drawContents(QPainter* p);
      virtual void resizeEvent(QResizeEvent*);
      virtual void mousePressEvent(QMouseEvent*);

   public slots:
      void resetPeaks();
      void setVal(int, int, bool);

   signals:
      void mousePress();

   public:
      Meter(QWidget* parent);
      void setRange(double min, double max);
      };

#endif

