//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: wav.h,v 1.3 2002/02/13 11:42:56 muse Exp $
//
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//  based on libsndfile:
//  Copyright (C) 1999-2000 Erik de Castro Lopo <erikd@zip.com.au>
//=========================================================

#ifndef WAV_H_INCLUDED
#define WAV_H_INCLUDED

struct MIN_WAV_FMT {	
      unsigned short    format;
	unsigned short	channels;
	unsigned int	samplerate;
	unsigned int	bytespersec;
	unsigned short	blockalign;
	unsigned short	bitwidth;
      };

struct WAV_FMT_SIZE20 {
      unsigned short	format;
	unsigned short	channels;
	unsigned int	samplerate;
	unsigned int	bytespersec;
	unsigned short	blockalign;
	unsigned short	bitwidth;
	unsigned short	extrabytes;
	unsigned short	dummy;
      };

struct MS_ADPCM_WAV_FMT {
      unsigned short	format;
	unsigned short	channels;
	unsigned int	samplerate;
	unsigned int	bytespersec;
	unsigned short	blockalign;
	unsigned short	bitwidth;
	unsigned short	extrabytes;
	unsigned short	samplesperblock;
	unsigned short	numcoeffs;
	struct {	
            short coeff1;
		short	coeff2;
	      } coeffs[7];
      };

struct IMA_ADPCM_WAV_FMT {
      unsigned short	format;
	unsigned short	channels;
	unsigned int	samplerate;
	unsigned int	bytespersec;
	unsigned short	blockalign;
	unsigned short	bitwidth;
	unsigned short	extrabytes;
	unsigned short	samplesperblock;
      };

struct EXT_SUBFORMAT {
      unsigned int	esf_field1;
	unsigned short	esf_field2;
	unsigned short	esf_field3;
	unsigned char	esf_field4[8];
      };

struct EXTENSIBLE_WAV_FMT {
      unsigned short	format;
	unsigned short	channels;
	unsigned int	samplerate;
	unsigned int	bytespersec;
	unsigned short	blockalign;
	unsigned short	bitwidth;
	unsigned short	extrabytes;
	unsigned short	validbits;
	unsigned int	channelmask;
	EXT_SUBFORMAT	esf;
      };

struct GSM610_WAV_FMT {
      unsigned short	format;
	unsigned short	channels;
	unsigned int	samplerate;
	unsigned int	bytespersec;
	unsigned short	blockalign;
	unsigned short	bitwidth;
	unsigned short	extrabytes;
	unsigned short	samplesperblock;
      };

union WAV_FMT {
      unsigned short		format;
	MIN_WAV_FMT			min;
	IMA_ADPCM_WAV_FMT	      ima;
	MS_ADPCM_WAV_FMT	      msadpcm;
	EXTENSIBLE_WAV_FMT	ext;
	GSM610_WAV_FMT		gsm610;
	WAV_FMT_SIZE20		size20;
	char				padding[512];
      };

struct FACT_CHUNK {
      unsigned int samples;
      };

//---------------------------------------------------------
//   SndFileFormat
//---------------------------------------------------------

class SndFileFormatWave : public SndFileFormat {
   public:
      SndFileFormatWave(SndFile* s) : SndFileFormat(s) {}
      virtual void close();
      };
#endif
