//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: poseditplug.cpp,v 1.1 2002/01/30 14:54:03 muse Exp $
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#include <qwidgetplugin.h>
#include "posedit.h"
#include "poslabel.h"
#include "pitchedit.h"
#include "pitchlabel.h"
#include "sig.h"
#include "tempo.h"

int sampleRate = 44100;
int division = 384;
int mtcType = 0;
bool hIsB = false;

static const char *posedit_pixmap[] = {
          "22 22 8 1",
          "  c Gray100",
          ". c Gray97",
          "X c #4f504f",
          "o c #00007f",
          "O c Gray0",
          "+ c none",
          "@ c Gray0",
          "# c Gray0",
          "++++++++++++++++++++++",
          "++++++++++++++++++++++",
          "++++++++++++++++++++++",
          "++++++++++++++++++++++",
          "+OOOOOOOOOOOOOOOOOOOO+",
          "OOXXXXXXXXXXXXXXXXXXOO",
          "OXX.          OO OO  O",
          "OX.      oo     O    O",
          "OX.      oo     O   .O",
          "OX  ooo  oooo   O    O",
          "OX    oo oo oo  O    O",
          "OX  oooo oo oo  O    O",
          "OX oo oo oo oo  O    O",
          "OX oo oo oo oo  O    O",
          "OX  oooo oooo   O    O",
          "OX            OO OO  O",
          "OO..................OO",
          "+OOOOOOOOOOOOOOOOOOOO+",
          "++++++++++++++++++++++",
          "++++++++++++++++++++++",
          "++++++++++++++++++++++",
          "++++++++++++++++++++++"
      };

static const char *pitchedit_pixmap[] = {
          "22 22 8 1",
          "  c Gray100",
          ". c Gray97",
          "X c #4f504f",
          "o c #00007f",
          "O c Gray0",
          "+ c none",
          "@ c Gray0",
          "# c Gray0",
          "++++++++++++++++++++++",
          "++++++++++++++++++++++",
          "++++++++++++++++++++++",
          "++++++++++++++++++++++",
          "+OOOOOOOOOOOOOOOOOOOO+",
          "OOXXXXXXXXXXXXXXXXXXOO",
          "OXX.          OO OO  O",
          "OX.      o      O    O",
          "OX.      oo     O   .O",
          "OX       o o    O    O",
          "OX       o      O    O",
          "OX     o o      O    O",
          "OX    oooo      O    O",
          "OX     o        O    O",
          "OX              O    O",
          "OX            OO OO  O",
          "OO..................OO",
          "+OOOOOOOOOOOOOOOOOOOO+",
          "++++++++++++++++++++++",
          "++++++++++++++++++++++",
          "++++++++++++++++++++++",
          "++++++++++++++++++++++"
      };

class PosEditPlugin : public QWidgetPlugin {
   public:
      PosEditPlugin() {}
      virtual ~PosEditPlugin() {}
      virtual QStringList keys() const;
      virtual QWidget* create(const QString& key, QWidget* parent=0,
        const char* name = 0);
      virtual QString group(const QString& key) const;
      virtual QIconSet iconSet(const QString& key) const;
      virtual QString includeFile(const QString& key) const;
      virtual QString toolTip(const QString& key) const;
      virtual QString whatsThis(const QString& key) const;
      virtual bool isContainer(const QString& key) const;
      };

QStringList PosEditPlugin::keys() const
      {
      QStringList list;
      list << "PosEdit" << "PitchEdit"
         << "PosLabel" << "PitchLabel";
      return list;
      }

QWidget* PosEditPlugin::create(const QString& key, QWidget* parent=0,
   const char* name = 0)
      {
      if (key == "PosEdit")
            return new PosEdit(parent, name);
      else if (key == "PitchEdit")
            return new PitchEdit(parent, name);
      else if (key == "PitchLabel")
            return new PitchLabel(parent, name);
      else if (key == "PosLabel")
            return new PosLabel(parent, name);
      return 0;
      }

QString PosEditPlugin::group (const QString& /*key*/) const
      {
      return QString("MusE");
      }

QIconSet PosEditPlugin::iconSet (const QString& key) const
      {
      if (key == "PosEdit" || key == "PosLabel")
            return QIconSet(QPixmap(posedit_pixmap));
      else if (key == "PitchEdit" || key == "PitchLabel")
            return QIconSet(QPixmap(pitchedit_pixmap));
      return QIconSet();
      }

QString PosEditPlugin::includeFile (const QString& key) const
      {
      if (key == "PosEdit")
            return "posedit.h";
      else if (key == "PitchEdit")
            return "pitchedit.h";
      else if (key == "PitchLabel")
            return "pitchlabel.h";
      else if (key == "PosLabel")
            return "poslabel.h";
      return QString::null;
      }

QString PosEditPlugin::toolTip (const QString& key) const
      {
      if (key == "PosEdit")
            return QString("midi time position editor");
      else if (key == "PitchEdit")
            return QString("midi pitch spinbox");
      else if (key == "PitchLabel")
            return QString("midi pitch label");
      else if (key == "PosLabel")
            return QString("midi time position label");
      return QString::null;
      }

QString PosEditPlugin::whatsThis (const QString& key) const
      {
      if (key == "PosEdit")
            return QString("midi time position editor");
      else if (key == "PitchEdit")
            return QString("midi pitch spinbox");
      else if (key == "PitchLabel")
            return QString("midi pitch label");
      else if (key == "PosLabel")
            return QString("midi time position label");
      return QString::null;
      }

bool PosEditPlugin::isContainer (const QString& /*key*/) const
      {
      return false;
      }

Q_EXPORT_PLUGIN(PosEditPlugin)

