//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: amixer.h,v 1.1.1.1 2003/10/29 10:05:24 wschweer Exp $
//
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __AMIXER_H__
#define __AMIXER_H__

#include <qlayout.h>
#include <qpixmap.h>
#include <qlistbox.h>
#include <list>

#include "cobject.h"
#include "synth.h"
#include "node.h"

#include <qtooltip.h>

class Xml;
class QWidget;
class QHBoxLayout;
class QScrollView;
class AudioThread;
class AudioNode;
class QGridLayout;
class Meter;
class RouteComboBox;
class AudioNodeButton;
class Track;
class QLabel;
class VolSlider;

#define EFX_HEIGHT     16
#define MAX_CHANNEL     2     // only mono/stereo
#define MAX_PLUGINS     4

enum { MASTER, GROUP, TRACK, INPUT, SYNTHI };

//---------------------------------------------------------
//   Strip
//---------------------------------------------------------

class Strip : public QObject {
      Q_OBJECT

   public:
      int type;
      int channel;
      QLabel* label;
      VolSlider* slider;

      AudioNode* src;
      Meter* meter[2];
      RouteComboBox* routeCombo;
      AudioNodeButton* mute;
      AudioNodeButton* record;
      AudioNodeButton* solo;

   public slots:
      void resetPeaks();

   public:
      Strip(int t) {
            channel = 0;
            type    = t;
            }
      ~Strip() {
            }
      };

//---------------------------------------------------------
//   AudioMixerApp
//---------------------------------------------------------

class AudioMixerApp : public TopWin {
      QScrollView* view;
      QWidget* central;
      QHBoxLayout* lbox;
      QGridLayout* grid;
      Strip* master;

      Q_OBJECT

      virtual void closeEvent(QCloseEvent* e);
      void readStatus(Xml&);
      void writeStatus(int, Xml&) const;
      Strip* genStrip(const QString& txt, int col, AudioNode*, int);
      void createMixer();
      virtual void customEvent(QCustomEvent*);
      void updateOutputRoute();

   signals:
      void deleted(int);

   private slots:
      void heartBeat();
      void recordToggled(bool, AudioNode*);
      void soloToggled(bool, AudioNode*);
      void muteToggled(bool, AudioNode*);
      void stereoToggled(bool, AudioNode*);
      void preToggled(bool, AudioNode*);
      void offToggled(bool, AudioNode*);
      void recFileDialog();
      void recordFlagChanged(Track*);
      void addInput();

   public slots:
      void songChanged(int);

   public:
      AudioMixerApp();
      void updateMixer();
      };

#endif

