//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: volslider.cpp,v 1.1.1.1 2003/10/29 10:05:23 wschweer Exp $
//
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#include <cmath>
#include "../audio.h"
#include "volslider.h"
#include "globals.h"

//---------------------------------------------------------
//   VolSlider
//---------------------------------------------------------

VolSlider::VolSlider(QWidget* parent, AudioNode* s)
   : Slider(parent, "vol", Slider::Vertical, Slider::None, Slider::BgTrough | Slider::BgSlot)
      {
      src = s;
      setRange(minSlider-0.1, 10.0);
      connect(this, SIGNAL(valueChanged(double)), SLOT(valueChanged(double)));
      }

//---------------------------------------------------------
//   volChanged
//---------------------------------------------------------

void VolSlider::valueChanged(double val)
      {
      double vol;
      if (val <= minSlider) {
            vol = 0.0;
            val -= 1.0; // display special value "off"
            }
      else
            vol = pow(10.0, val/20.0);
      audio->msgSetVolume(src, vol);
      emit volChanged(val);
      }

