/***************************************************************************
                          dir.h  -  description
                             -------------------
    begin                : Sat Sep 1 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifndef _DIR_H_INCLUDED_
#define _DIR_H_INCLUDED_

struct DirEntry {
    enum DirEntryType{
        notdef  = 0x0000,
        regular = 0x0001,
        dir     = 0x0002,
        link    = 0x0004,
        chr_dev = 0x0008,
        blk_dev = 0x0010,
        fifo    = 0x0020,
        socket  = 0x0040
    };
    CString Name;
    CString Path;
    size_t  Size;

    time_t  AccessTime;    // time of last access
    time_t  ModifyTime;     // time of last modification
    time_t  ChangeTime;    // time of last change

    int Type;
    //
    DirEntry() :
        Size(0),
        AccessTime(0),
        ModifyTime(0),
        ChangeTime(0),
        Type(notdef)
    {}
    DirEntry(const DirEntry& orig) :
        Name(orig.Name),
        Path(orig.Path),
        Size(orig.Size),
        AccessTime(orig.AccessTime),
        ModifyTime(orig.ModifyTime),
        ChangeTime(orig.ChangeTime),
        Type(orig.Type)
    {}
    const DirEntry& operator=(const DirEntry& orig){
        Name = orig.Name;
        Path = orig.Path;
        Size = orig.Size;
        AccessTime = orig.AccessTime;
        ModifyTime = orig.ModifyTime;
        ChangeTime = orig.ChangeTime;
        Type = orig.Type;
    }
};

enum ScanDirSort{
    SORT_ASENDING  = 0x0000,
    SORT_DESENDING = 0x8000,
    SORT_NONE      = 0x0000,
    SORT_BYNAME    = 0x0001,
    SORT_BYSIZE    = 0x0002,
    SORT_BYATIME   = 0x0003,
    SORT_BYMTIME   = 0x0004,
    SORT_BYCTIME   = 0x0005
};

typedef vector<DirEntry> DirEntryVec;

bool ScanDir( DirEntryVec& result,
              const CString &path,
              const CString &nameFilter, int typeFilter = DirEntry::regular, int sortSpec = SORT_NONE);

#endif //_DIR_H_INCLUDED_
