/*
 *   meiovect.c -- MEIO Manager IOCTL routing functions
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <port_types.h> 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>

#include "meio_api.h"          /* MEIO API Definitions                    */
#include "meioddr2.h"          /* MEIO Device Driver definitions          */
#if defined(xWORLDTRADE_VERSION)
#include <meiowtac.h>
#endif

UCHAR     MeioBusyFlag = 0;       /* current state of MEIO interface  CH01*/

/*------------------------------------------------------------------------*/
/* MeioAPIDispatch()                                                      */
/*------------------------------------------------------------------------*/
APIRET FAR PASCAL MeioAPIDispatch(  /* function to dispatch IDC or IOCTL */
                                     /* to MEIO core code.                */
          USHORT         usFunction, /* IDC function to perform           */
          VOID FARPTR16  fp16Args)   /* Function Arguments                */
{
  APIRET                                 RC = 0;                  
  MEIO_IOCTL_OPEN_PARMS        FARPTR16  MoP;
  MEIO_IOCTL_CLOSE_PARMS       FARPTR16  MclP;
  MEIO_IOCTL_QUERYAB_PARMS     FARPTR16  MqaP;
  MEIO_IOCTL_CONNECT_PARMS     FARPTR16  McP;
  MEIO_IOCTL_DISCONNECT_PARMS  FARPTR16  MdP;
  MEIO_IOCTL_UPDATECON_PARMS   FARPTR16  MucP;
  MEIO_IOCTL_QUERYCON_PARMS    FARPTR16  MqcP;
  MEIO_IOCTL_RESYNC_PARMS      FARPTR16  MrsP;                    
#if defined(xWORLDTRADE_VERSION)
  MEIO_IOCTL_SETWTDATA_PARMS   FARPTR16  MswdP;
#endif
  
  
  MW_SYSLOG_2(TRACE_MEIO_CORE,"meiovect::MeioAPIDispatch entry usFunction %x\n",usFunction);

  ++MeioBusyFlag;                /* update to busy state   */
  

  if (MeioBusyFlag > 1) {
    ((MEIO_IOCTL_GENERIC_PARMS FARPTR16)fp16Args)->ulRC = MEIO_BUSY;
  } else {
    switch (usFunction) {
    case MEIO_IOCtl_Open:
      MoP = (MEIO_IOCTL_OPEN_PARMS FARPTR16)fp16Args;
      MoP->ulRC = dspMeioOpeni(
			       MoP->hDsp,      /* Handle of DSP device from DSPMGR  */
			       MoP->phMeio,    /* Handle of MEIO Instance returned  */
			       MoP->ulOptions  /* reserved - must be 0              */
			       );
      break;

    case MEIO_IOCtl_Close:
      MclP = (MEIO_IOCTL_CLOSE_PARMS FARPTR16)fp16Args;
      MclP->ulRC = dspMeioClosei(
				 MclP->hMeio,     /* Handle of MEIO Instance returned  */
				 MclP->ulOptions  /* reserved - must be 0              */
				 );
      break;
      
    case MEIO_IOCtl_Query_Abilities:
      MqaP = (MEIO_IOCTL_QUERYAB_PARMS FARPTR16)fp16Args;
      MqaP->ulRC = dspMeioQueryi(
				 MqaP->hMeio,          /* MEIO Handle     */
				 MqaP->sRequest,       /* query type      */
				 MqaP->fp16Buffersize, /* sizeof buf      */
				 MqaP->fp16Buffer      /* return data buf */
				 );
      break;
      
      
    case MEIO_IOCtl_Connect:
      McP = (MEIO_IOCTL_CONNECT_PARMS FARPTR16)fp16Args;
      McP->ulRC = dspMeioConnecti(
				  McP->hMeio,          /* MEIO Handle               */
				  McP->fp16Connection, /* THE Connection is returned*/
				  McP->OwnerPort,      /* Connection Owner          */
				  McP->UserPort,       /* Connection User           */
				  McP->SharingOptions, /* willingness to share      */
				  McP->ulState,        /* connection state   CH02   */
				  McP->Reserved        /* reserved - must be 0      */
				  );
      break;
      
      
    case MEIO_IOCtl_Disconnect:
      MdP = (MEIO_IOCTL_DISCONNECT_PARMS FARPTR16)fp16Args;
      MdP->ulRC = dspMeioDisconnecti(
				     MdP->hConnection, /* handle returned by     */
				     /* dspMeioConnect()       */
				     MdP->Reserved     /* change sharing on disconnect */
				     );
      break;
      

    case MEIO_IOCtl_UpdateConnection:
      MucP = (MEIO_IOCTL_UPDATECON_PARMS FARPTR16)fp16Args;
      MucP->ulRC = dspMeioUpdateConnectioni(
					    MucP->hConnection, /* handle returned by     */
					    /* dspMeioConnect()       */
					    (MEIO_CONNECTATTRIBUTE)MucP->sAttribute,
					    MucP->lValue
					    );
      break;
      
      
    case MEIO_IOCtl_QueryConnection:
      MqcP = (MEIO_IOCTL_QUERYCON_PARMS FARPTR16)fp16Args;
      MqcP->ulRC = dspMeioQueryConnectioni(
					   MqcP->hConnection, /* handle returned by     */
					   /* dspMeioConnect()       */
					   (MEIO_CONNECTATTRIBUTE)MqcP->sAttribute,
					   MqcP->fp16lValue
					   );
      break;

      
    case MEIO_IOCtl_Resync:
      MrsP = (MEIO_IOCTL_RESYNC_PARMS FARPTR16)fp16Args;
      MrsP->ulRC = dspMeioResynci(
				  (MEIO_OBJ_TYPE)MrsP->sObjectType
				  ,MrsP->Object
				  ,MrsP->ulOptions
				  );
      break;
      

    case MEIO_IOCtl_Restart:
      MEIOrestart();
      ((MEIO_IOCTL_GENERIC_PARMS FARPTR16)fp16Args)->ulRC = MEIO_NOERROR;
      break;
      

    case MEIO_IOCtl_Stop:
      MEIOstop();
      ((MEIO_IOCTL_GENERIC_PARMS FARPTR16)fp16Args)->ulRC = MEIO_NOERROR;
      break;
      
#if defined(xWORLDTRADE_VERSION)

    case MEIO_IOCtl_SetWTdata:
      MswdP = (MEIO_IOCTL_SETWTDATA_PARMS FARPTR16)fp16Args;
      WtDataCache(MswdP->usNumWords,
		  MswdP->fp16usData);
      MswdP->ulRC = 0;
      break;
      
    case MEIO_IOCtl_SetWTdataX:
      MswdP = (MEIO_IOCTL_SETWTDATA_PARMS FARPTR16)fp16Args;
      WtDataXCache(MswdP->usNumWords,
		   MswdP->fp16usData);
      MswdP->ulRC = 0;
      break;
#endif
      
    default:   
      RC = MEIO_SYS_BAD_FUNCTION;                
      break;
    } 
    
  }
  MeioBusyFlag--;   

  MW_SYSLOG_2(TRACE_MEIO_CORE,"meiovect::MeioAPIDispatch exit RC %lx\n",RC);
  return(RC);     
}
