/*
 *   mwmutil.c -- Mwave Configuration Utility routines
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <port_types.h>
#include <port_functions.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <errno.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>

static void *region=NULL;
static int fileSize=0;
static char file[0x10000];

int   readFile(LPCTSTR lpFileName);
char *getKey(LPCTSTR lpKeyName, LPCTSTR lpSectionName, LPCTSTR lpFileName);


UINT GetPrivateProfileInt(LPCTSTR lpSectionName, // section name, bracket delimited
			  LPCTSTR lpKeyName,     // key name
			  INT nDefault,          // return value if key name not found
			  LPCTSTR lpFileName     // file name
			  ) {
  char *keyValue=NULL;
  UINT intValue;
  char section_name[256];
   
  MW_SYSLOG_5(TRACE_MWMUTIL,"mwmutil::GetPrivateProfileInt lpSectionName=%s lpKeyName=%s nDefault=%d lpFileName=%p\n", lpSectionName, lpKeyName, nDefault, lpFileName);
  
  section_name[0]='[';
  memcpy(&section_name[1],lpSectionName,strlen(lpSectionName));
  section_name[strlen(lpSectionName)+1]=']';
  section_name[strlen(lpSectionName)+2]=0;
  MW_SYSLOG_2(TRACE_MWMUTIL,"mwmutil::GetPrivateProfileInt section_name %s\n",section_name);
  
  keyValue=getKey(lpKeyName, section_name, lpFileName);
  MW_SYSLOG_2(TRACE_MWMUTIL,"mwmutil::GetPrivateProfileInt, keyValue=%s\n", keyValue);
  
  if(keyValue != NULL) {
    intValue = (UINT)atoi(keyValue);
  } else {
    intValue = (UINT)nDefault;
  }/*if-else*/
  
  MW_SYSLOG_2(TRACE_MWMUTIL,"mwmutil::GetPrivateProfileInt retVal=%u\n", intValue);
  return intValue;
  
} /*GetPrivateProfileInt*/


DWORD GetPrivateProfileString(LPCTSTR lpSectionName,   // section name, bracket delimited
			      LPCTSTR lpKeyName,       // key name
			      LPCTSTR lpDefault,       // default string
			      LPTSTR lpReturnedString, // destination buffer
			      DWORD nSize,             // size of destination buffer
			      LPCTSTR lpFileName       // profile file name
			      ) {
  DWORD cSize;
  char *keyValue;
  char section_name[256];

  MW_SYSLOG_7(TRACE_MWMUTIL,"mwmutil::GetPrivateProfileString lpSectionName=%s lpKeyName=%s lpDefault=%s lpReturnedString=%p nSize=%lu lpFileName=%p\n", lpSectionName, lpKeyName, lpDefault, lpReturnedString, nSize, lpFileName);

  section_name[0]='[';
  memcpy(&section_name[1],lpSectionName,strlen(lpSectionName));
  section_name[strlen(lpSectionName)+1]=']';
  section_name[strlen(lpSectionName)+2]=0;
  MW_SYSLOG_2(TRACE_MWMUTIL,"mwmutil::GetPrivateProfileString section_name %s\n",section_name);
  
  keyValue = getKey(lpKeyName, section_name, lpFileName);
  MW_SYSLOG_2(TRACE_MWMUTIL,"mwmutil::GetPrivateProfileString, keyValue=%s\n", keyValue);
  
  if(keyValue != NULL) {
    strcpy(lpReturnedString, keyValue);
    cSize = strlen(lpReturnedString);
  } else {
    strcpy(lpReturnedString, lpDefault);
    cSize = strlen(lpReturnedString);
  }
  
  MW_SYSLOG_3(TRACE_MWMUTIL,"mwmutil::GetPrivateProfileString lpReturnedString=%s cSize=%lu\n", lpReturnedString, cSize);
  return cSize;

} /*GetPrivateProfileString*/

DWORD WritePrivateProfileString(LPCTSTR lpSectionName, // section name, bracket delimited
			      LPCTSTR lpKeyName,       // key name
			      LPCTSTR lpString,        // string to write
			      LPCTSTR lpFileName       // profile file name
			      ) {
  MW_SYSLOG_1(TRACE_MWMUTIL,"mwmutil::WritePrivateProfileString entry\n");
  MW_SYSLOG_1(TRACE_MWMUTIL,"mwmutil::WritePrivateaProfileString exit, UNSUPPORTED FUNCTION\n");
  return 0;
}

int readFile(LPCTSTR lpFileName) {
  int fd;
  struct stat sb;

  MW_SYSLOG_2(TRACE_MWMUTIL,"mwmutil::readFile entry lpFileName %s\n",lpFileName);
  if (lpFileName) {    
    MW_SYSLOG_2(TRACE_MWMUTIL,"mwmutil::readFile entry lpFileName=%s\n", (char *)lpFileName);
  } else {
    MW_SYSLOG_ERROR(LOG_ERR,"mwmutil::readFile ERROR Config File Name is NULL\n");
    return 1;
  }


  if((fd = open(lpFileName, O_RDONLY)) < 0) {
    MW_SYSLOG_ERROR(LOG_ERR,"mwmutil::readFile, ERROR Could not open mwave modem config file %s!!!\n",lpFileName);
    return 1;
  }
  
  if(fstat(fd, &sb)) {
    MW_SYSLOG_ERROR(LOG_ERR,"mwmutil::readFile, ERROR Could not fstat modem config file %s!!!\n",lpFileName);
    return 1;
  }
  
  fileSize = (int)sb.st_size;

  MW_SYSLOG_2(TRACE_MWMUTIL,"mwmutil::readFile, fileSize %x\n",fileSize);

  region=mmap(NULL, sb.st_size, PROT_READ, MAP_SHARED, fd, 0);

  MW_SYSLOG_2(TRACE_MWMUTIL,"mwmutil::readFile, region %p\n",region);

  if(region == ((caddr_t) -1)) {
    MW_SYSLOG_ERROR(LOG_ERR,"mwmutil::readFile, ERROR Could not mmap config file %s!!!\n",lpFileName);
    return 1;
  }

  //file=malloc(fileSize);

  close(fd);
  
  MW_SYSLOG_1(TRACE_MWMUTIL,"mwmutil::readFile exit OK\n");
  return 0;

} /*readFile*/

/* Give a file buffer, find a return ptr to section name (or NULL if not found) */
char * getSection(LPCTSTR lpSectionName,char *file) {    // Section name, bracket delimited
  char *line;
  char *section = NULL;
  
  MW_SYSLOG_4(TRACE_MWMUTIL,"mwmutil::getSection entered, lpSectionName %s, region %p, file %p\n",
	 lpSectionName,region,file);
  
  line = strtok(file, "\n");
  //  MW_SYSLOG_2(TRACE_MWMUTIL,"mwmutil::getSection, line %s\n",line);
  
  do {
    if((section=strcasestr(line, lpSectionName)) != NULL) {
      MW_SYSLOG_3(TRACE_MWMUTIL,"mwmutil::getSection, got lpSectionName %s at index %p\n",lpSectionName,section);
      break;
    }
    line = strtok(NULL, "\n");
    //    MW_SYSLOG_2(TRACE_MWMUTIL,"mwmutil::getSection, line %s\n",line);
  } while(line != NULL);
 
  if (section) {
    MW_SYSLOG_2(TRACE_MWMUTIL,"mwmutil::getSection, exit section %s\n",section);
  } else {
    MW_SYSLOG_2(TRACE_MWMUTIL,"mwmutil::getSection, ERROR lpSectionName %s not found\n",lpSectionName);
  }

   return section;
} /*getSection*/


/* Returns char * to value (or NULL if not found)                          */
char * getKey(LPCTSTR lpKeyName,       // Key name (ends with an = sign)
	      LPCTSTR lpSectionName,   // Section name, bracket delimited
	      LPCTSTR lpFileName) {    // profile file name
  char *line;
  char *value= NULL;
  char *section = NULL;
  
  MW_SYSLOG_4(TRACE_MWMUTIL,"mwmutil::getKey entered, lpKeyName %s, lpSectionName %s, lpFileName %p\n",
	 lpKeyName,lpSectionName,lpFileName);


  if (region == NULL) {
    readFile(lpFileName);
  }
  if (!region) {
    MW_SYSLOG_2(TRACE_MWMUTIL,"mwmutil::getKey, ERROR unable to read lpFileName %p\n",lpFileName);
  } else {
    strcpy(file,(char *)region);

    section=getSection(lpSectionName,file);
    if (!section) {
      MW_SYSLOG_2(TRACE_MWMUTIL,"mwmutil::getKey, ERROR unable to find lpSectionName %s\n",lpSectionName);
    } else {
      strcpy(file, (char *)region);
      line = strtok(section, "\n");
      //      MW_SYSLOG_2(TRACE_MWMUTIL,"mwmutil::getKey, line %s\n",line);
      line = strtok(NULL, "\n");
      //      MW_SYSLOG_2(TRACE_MWMUTIL,"mwmutil::getKey, line %s\n",line);
      
      do {
	if (strchr(line,'[')) { // If end of the section
	  break;
	}
	if((value=strcasestr(line, lpKeyName)) != NULL) {
	  MW_SYSLOG_3(TRACE_MWMUTIL,"mwmutil::getKey, got lpKeyName %s at index %p\n",lpKeyName,value);
	  value += strlen(lpKeyName);
          MW_SYSLOG_2(TRACE_MWMUTIL,"mwmutil::getkey, 1st byte following key %x\n",value[0]);
	  if (value[0] != '=') {
            MW_SYSLOG_2(TRACE_MWMUTIL,"mwmutil::getKey, value[0] %x not =, skipping\n",value[0]);
          } else {
            value += 1;
	    MW_SYSLOG_3(TRACE_MWMUTIL,"mwmutil::getKey, got value %s at index %p\n",value,value);
	    break;
          }
	}
	line = strtok(NULL, "\n");
	//	MW_SYSLOG_2(TRACE_MWMUTIL,"mwmutil::getKey, line %s\n",line);
      } while(line != NULL);
    }
  } 
  if (value) {
    MW_SYSLOG_2(TRACE_MWMUTIL,"mwmutil::getKey, exit value %s\n",value);
  } else {
    MW_SYSLOG_2(TRACE_MWMUTIL,"mwmutil::getKey, ERROR lpKeyName %s not found\n",lpKeyName);
  }
  return value;
}
