// arrayfunction.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// ArrayFunction is the abstract base class for a series of subclasses which
// take an array of doubles (via the () operator) representing a block of sound
// data, and load their output (usually the results of an analysis) into the
// Data instance 'frame'.  The doApply() method is redefined in ArrayFunction
// to allow these subclasses to function identically to other ProcessFunction
// subclasses via the Modifier::apply() method (in the root base class)

#ifndef ARRAYFUNCTION_H
#ifdef __GNUG__
#pragma interface
#endif
#define ARRAYFUNCTION_H

#include "localdefs.h"
#include "analysisfun.h"

class Data;

class ArrayFunction : public AnalysisFunction {
public:
	ArrayFunction(Data* data, int flen, int foffset)
		: AnalysisFunction(data), frameLength(flen), frameOffset(foffset) {}
	virtual int operator () (double *input, Data *frame) = 0;
protected:
	ArrayFunction(Data* data)
		: AnalysisFunction(data), frameLength(0), frameOffset(0) {}
	redefined int doApply(Data *data);
	int framesize() { return frameLength; }
	int offset() { return frameOffset; }
	double framerate() { return sampRate() / double(offset()); }
	boolean setBaseValues(int flen, double frate, int foffset);
	void setFrameLength(int flen) { frameLength = flen; }
	void setOffset(int o) { frameOffset = o; }
	virtual int maxFrameLength()=0;
	virtual int initialOffset();
	redefined int analysisLength();
private:
	int frameLength;
	int frameOffset;
};

#endif
