// framebuffer.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// The FrameBuffer class, currently unused, will be used in processing
// algorithms that need overlap-and-add output capability.  It functions like
// the Buffer base class, but allows values to be added to those present in
// the queue, rather than merely replacing them.

#ifndef FRAMEBUFFER_H
#ifdef __GNUG__
#pragma interface
#endif
#define FRAMEBUFFER_H

#include "buffer.h"

class FrameBuffer : public Buffer {
	typedef Buffer Super;
public:
	FrameBuffer(int size) : Buffer(size) { zero(); }
	virtual ~FrameBuffer() {}
	void reset();
	FrameBuffer& addTo(double value);
	double takeFrom();
	boolean empty();
	void offset(int amount);
protected:
	void zero() { bzero((char *) buffer, maxQueue * sizeof(double)); }
};

inline void
FrameBuffer::reset() { Super::reset(); zero(); }

inline boolean
FrameBuffer::empty() { return inputPointer == outputPointer; }

inline Buffer&
FrameBuffer::addTo(double value) {
	*inputPointer += value;
	incrementInput();
	return *this;
}

inline double
FrameBuffer::takeFrom() {
	double output = *outputPointer;
	*outputPointer = 0.0;
	incrementOutput();
	return output;
}

inline void
FrameBuffer::offset(int amount) {
	inputPointer += (amount % maxQueue);
	inputPointer += (inputPointer > bufferEnd) ? -maxQueue :
		(inputPointer < buffer) ? maxQueue : 0;
}

#endif

