// textfile.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// This class is unused at this time.

#ifndef BFILE_H 
#ifdef __GNUG__
#pragma interface
#endif
#define BFILE_H

#include "diskfile.h"

class TextFile : public DiskFile {
protected:
	char		*readline (int chunk_number, char terminator);
public:
	TextFile() {}
	TextFile(const char* filename, io_mode m, access_mode a);
	TextFile(const char* filename, const char* m);

	virtual ~TextFile() {}

// binding, rebinding, unbinding to physical files

  DiskFile&			open(const char* filename, io_mode m, access_mode a);
  DiskFile&			open(const char* filename, const char* m);
  TextFile&         open(int  filedesc, io_mode m);
  TextFile&         open(FILE* fileptr);
  
  TextFile& 	    failif(int cond);

// character IO

  TextFile&         get(char& c);
  TextFile&         put(char  c);
  TextFile&         unget(char c);
  TextFile&         putback(char c); // a synonym for unget

// char* IO

  TextFile&         put(const char* s);
  TextFile&         get    (char* s, int n, char terminator = '\n');
  TextFile&         getline(char* s, int n, char terminator = '\n');
  TextFile&         gets   (char **s, char terminator = '\n');

// binary IO

  TextFile&         read(void* x, int sz, int n);
  TextFile&         write(const void* x, int sz, int n);

// formatted IO

  TextFile&         form(const char* ...);
  TextFile&         scan(const char* ...);

// buffer IO

  TextFile&         flush();
  TextFile&         flush(char ch); // call stdio _flsbuf
  int 		        fill();         // call stdio _filbuf

};

inline TextFile& TextFile::failif(int cond) {
	DiskFile::failif(cond);
	return *this; 
}

inline TextFile& TextFile::read(void* x, int sz, int n)
{ 
  return failif (!readable() || (stat = fread(x, sz, n, fp)) != n);
} 

inline TextFile& TextFile::write(const void* x, int sz, int n) 
{ 
  return failif (!writable() || (stat = fwrite(x, sz, n, fp)) != n);
}

inline TextFile& TextFile::get(char& c)
{ 
  if (readable())
  {
    int ch = getc(fp);
    c = ch;
    failif (ch == EOF);
  }
  return *this;
}

inline TextFile& TextFile::put(char  c) 
{ 
  return failif (!writable() ||  putc(c, fp) == EOF);
}

inline TextFile& TextFile::unget(char c)
{ 
  return failif(!is_open() || !(rw & 01) || ungetc(c, fp) == EOF);
} 

inline TextFile& TextFile::putback(char c)
{ 
  return failif (!is_open() || !(rw & 01) || ungetc(c, fp) == EOF);
}

inline TextFile& TextFile::flush()
{ 
  return failif(!is_open() || fflush(fp) == EOF);
}

inline TextFile& TextFile::flush(char ch)
{ 
#ifdef VMS
  return failif(!is_open() || c$$flsbuf(ch, fp) == EOF);
#else
  return failif(!is_open() || _flsbuf(ch, fp) == EOF);
#endif
}

inline int TextFile::fill()
{ 
#ifdef VMS
  failif(!is_open() || (stat = c$$filbuf(fp)) == EOF);
#else
  failif(!is_open() || (stat = _filbuf(fp)) == EOF);
#endif
  return stat;
}

#endif
