#ifndef QUERYLISTVIEW_H
#define QUERYLISTVIEW_H

#include <qlistview.h>
#include <qmap.h>
#include <mysql.h>

#define SQL_ERROR		-1
#define SQL_NOSCHEMA	0
#define SQL_SCHEMA		1	
#define SQL_SIMPLE		2		

#include "mainwindowglobal.h"

class QueryListView : public QListView
{
Q_OBJECT

public:
	QueryListView(MYSQL *,struct __global__ *, QWidget *);
	~QueryListView();

	void set_sql(const QString &, const QString &, const QString &table = "");
	int execute();
	int get_field_number() { return field_number; };
	int get_record_number() { return record_number; };

public slots:
	void slot_clear();
	void slot_close();
	void slot_save();
	void slot_about();
	void slot_sort(int);

private:
	QString database;
	QString sql;
	QString table;	
	MYSQL *mysql;
	MYSQL_RES *result;
	MYSQL_ROW row; 
	MYSQL_FIELD *field;
	int field_number;
	int record_number;
	bool flag;
	bool escape;	
	QMap<unsigned int, int> type;
	// key: index, value: type
	QListViewItem *dummy;
	struct __global__ *global;

	QString table_name();
	bool is_simple_query();
	void slot_row_height(QListViewItem *);
	int newline_number(const QString &);
	QListViewItem *get_last();

signals:
	void signal_error();

private:
	void signal_connect();

private slots:
	void slot_click(QListViewItem *, const QPoint &, int);
	void slot_delete(int);
	void slot_insert(int);
	void slot_update(int);
	void slot_refresh(int);
	void slot_sql_success();
};

#endif
