#ifndef SCHEMA_H
#define SCHEMA_H

#include <qlistview.h>
#include <mysql.h>
#include <qmap.h>

class Schema: public QListView 
{
Q_OBJECT

public:
	Schema(MYSQL *, const QString &, const QString &, QWidget *widget = 0, const char *name =0);
	~Schema();

private slots:
	void slot_expand(QListViewItem *);
	void slot_collapse(QListViewItem *);


public slots:
	void slot_schema();

private:
	void set_table(QListViewItem *);
	void set_field(QListViewItem *);

	MYSQL *mysql;
	QString host;
	QString user;

	QMap<QString, bool> database;
	QMap<QString, bool> table;
};

#endif
