/***************************************************************************
                          opendialog.cpp  -  description
                             -------------------
    begin                : Mon Oct 23 2000
    copyright            : (C) 2000 by shi bok jang
    email                : sise15@mizi.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "connect.h"

#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qcombobox.h>
#include "serverlistviewitem.h"

void Connect::slot_socket()
{
	QString l = QFileDialog::getOpenFileName();

	if(!l.isEmpty())
	{
		socket->setText(l);
	}
}

void Connect::slot_new()
{
	host->setText("");
	user->setText("");
	password->setText("");
	database->setText("");
	port->setText("");
	socket->setText("");

	host->setFocus();

	list->clearSelection();
}

void Connect::slot_save()
{
	if(host->text().isEmpty())
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Please enter host."));
		return;
	}

	ServerListViewItem *l = (ServerListViewItem *)list->selectedItem();
	
	if(l == NULL)
	{
		new ServerListViewItem(list, get_last(), host->text(), host->text(), user->text(), password->text(), database->text(), port->text(), socket->text());
	}
	else
	{
		l->host = host->text();
		l->user = user->text();
		l->password = password->text();
		l->database = database->text();
		l->port = port->text();
		l->socket = socket->text();
	}

	//new ServerListViewItem(list, get_last(), host->text(), host->text(), user->text(), password->text(), database->text(), port->text(), socket->text());
}

void Connect::slot_drop()
{
	list->removeItem(list->selectedItem());
}

void Connect::slot_server(QListViewItem *l)
{
	if(l == NULL)
	{
		return;
	}

	list->setSelected(l, TRUE);

	host->setText(((ServerListViewItem *)l)->host);
	user->setText(((ServerListViewItem *)l)->user);
	password->setText(((ServerListViewItem *)l)->password);
	database->setText(((ServerListViewItem *)l)->database);
	port->setText(((ServerListViewItem *)l)->port);
	socket->setText(((ServerListViewItem *)l)->socket);
}

QListViewItem *Connect::get_last()
{
	QListViewItem *l;
	QListViewItem *last;

	l = list->firstChild();

	if(l == NULL)
	{
		return NULL;
	}

	last = l;
	
	while(TRUE)
	{
		l = l->itemBelow();

		if(l == NULL)
		{
			break;
		}

		last = l;
	}

	return last;
}

void Connect::slot_up()
{
	if(list->firstChild() == NULL)
		return;
	
	QListViewItem *l = list->selectedItem()->itemAbove();

	if(l == NULL)
	{
		return;
	}

	l = l->itemAbove();

	if(l == NULL)
	{
		list->firstChild()->moveItem(list->selectedItem());
		return;
	}

	list->selectedItem()->moveItem(l);
}

void Connect::slot_down()
{
	if(list->firstChild() == NULL)
		return;
	
	QListViewItem *l = list->selectedItem()->itemBelow();

	if(l == NULL)
	{
		return;
	}

	list->selectedItem()->moveItem(l);
}

void Connect::slot_close()
{
	flag = FALSE;
}
