#include "edit.h"
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qvbox.h>
#include <qstatusbar.h>
#include <qpixmap.h>
//#include "background.xpm"
#include "window.xpm"

Edit::Edit(QWidget *parent,const char *, int)
	: QMainWindow(parent, "MySQL Navigator", WStyle_Customize | WStyle_Title | WStyle_NormalBorder | WStyle_SysMenu | WStyle_ContextHelp | WStyle_DialogBorder | WStyle_ContextHelp) 
{
	make_central_widget();	

	make_menubar();	
	
	//work_space->setBackgroundPixmap(QPixmap(background_xpm));

	setIcon(QPixmap(window_xpm));
}

Edit::~Edit()
{
}

void Edit::make_menubar()
{
	QPopupMenu *si = new QPopupMenu();
	si->insertItem(tr("&New"), this, SLOT(slot_new()));
	si->insertItem(tr("&Open"), this, SLOT(slot_open()));
	si->insertItem(tr("&save"), this, SLOT(slot_save()));
	si->insertItem(tr("Save &as..."), this, SLOT(slot_save_as()));
	si->insertSeparator();
	//si->insertItem("&Print", this, SLOT(slot_print()));
	//si->insertSeparator();
	si->insertItem(tr("&Close"), this, SLOT(slot_close()));
	si->insertItem(tr("&Quit"), this, SLOT(slot_quit()));
	menuBar()->insertItem(tr("&File"), si);
	
	si = new QPopupMenu();
	si->insertItem(tr("&Undo"), this, SLOT(slot_undo()));
	si->insertItem(tr("&Redo"), this, SLOT(slot_redo()));
	si->insertSeparator();
	si->insertItem(tr("&Cut"), this, SLOT(slot_cut()));
	si->insertItem(tr("C&opy"), this, SLOT(slot_copy()));
	si->insertItem(tr("&Paste"), this, SLOT(slot_paste()));
	//si->insertItem("Paste &special...", this, SLOT(slot_paste_special()));
	si->insertItem(tr("C&lear"), this, SLOT(slot_clear()));
	si->insertSeparator();
	si->insertItem(tr("Select &All"), this, SLOT(slot_select_all()));
	menuBar()->insertItem(tr("&Edit"), si);
	
	si = new QPopupMenu();
	si->insertItem(tr("&About..."), this, SLOT(slot_about()));
	menuBar()->insertItem(tr("&Help"), si);
}

void Edit::make_central_widget()
{
	QVBox *k=new QVBox(this);
	k->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken );
    work_space = new QWorkspace(k);
    setCentralWidget(k);
				 
    statusBar()->message( tr("Ready..."), 3000 );   
}

void Edit::closeEvent(QCloseEvent *s)
{
	slot_quit();

	s->accept();
}
