#include <qfile.h>
#include <qtextstream.h>
#include <qfiledialog.h>
#include <qpixmap.h>
#include <qmessagebox.h>

#include "document.xpm"
#include "file.h"

File::File(QWidget *parent,const char *, int)
	: QMainWindow(parent, "MySQL Navigator", WStyle_Customize | WStyle_Title | WStyle_NormalBorder | WStyle_SysMenu | WStyle_ContextHelp | WStyle_DialogBorder | WStyle_ContextHelp) 
{
	edit = new QMultiLineEdit(this);

	setCentralWidget(edit);

	statusBar();
	
	setIcon(QPixmap(document_xpm));

	flag = FALSE;

	signal_connect();
}

File::~File()
{
}

void File::load(const QString &si)
{
	QFile f(si);

	name = si;
	
	if(!f.open(IO_ReadOnly))
	{
		return;
	}

	edit->setAutoUpdate(FALSE);
	edit->clear();

	QTextStream t(&f);
    
	while (!t.eof()) 
	{
	    QString s = t.readLine();
        edit->append(s);
    }
	f.close();

	edit->setAutoUpdate(TRUE);
	edit->repaint();

	flag = FALSE;
}

void File::save()
{
	if(name.isEmpty())
	{
		save_as();
        return;
    }

    QString text = edit->text();
 
	QFile l(name);
 
	if (!l.open(IO_WriteOnly)) 
	{
		emit signal_message(QString(tr("Can not write to %1")).arg(name), 3000);
	    return;
    }

    QTextStream si(&l);
    si << text;
    l.close();

    setCaption(name);

	flag = TRUE;
}

void File::save_as()
{
	QString si = QFileDialog::getSaveFileName(name, QString::null, this);
	if(!si.isEmpty()) 
	{
    	name = si;
        save();
    } 
	else 
	{
		emit signal_message(tr("Saving aborted"), 3000);
    }
}

void File::closeEvent(QCloseEvent *si)
{
	if(flag == FALSE)
	{
		int l = QMessageBox::warning (this, tr("MySQL Navigator"), tr("File is not saved. Do you want to save it now?"), tr("Yes"), tr("No"));

		if(l == 0)
		{
			if(name.isEmpty())
			{
				save_as();
			}
			else
			{
				save();
			}
		}
	}

	si->accept();
}
