#include <qvbox.h>
#include <qlabel.h>
#include <qtooltip.h>
#include <qmenubar.h>
#include <qmessagebox.h>
#include <qvaluelist.h>
#include <qpixmap.h>
#include <qstatusbar.h>
#include <qlistview.h>

#include "mainwindow.h"
#include "mdiwindow.h"
#include "tree.h"
#include "resource.h"

MainWindow::MainWindow(QApplication *l) :
QMainWindow(0,QString::fromLocal8Bit("MySQL Navigator"),WDestructiveClose)
{
	application = l;	

	initialize();
}

MainWindow::~MainWindow()
{
}	

void MainWindow::initialize()
{
	make_layout();

	signal_connect();

	flag = FALSE;

	mysql_init(&mysql);

	dialog = NULL;

	dummy = NULL;

	slot_windows();

	load_session();

	resize(global.size);

	disable_menu();

	make_connect_dialog();

	slot_display_background();
}

void MainWindow::set_base_color(QWidget *widget,QColor color)
{
	QPalette l(widget->palette());

	l.setColor(QColorGroup::Base,color);

	widget->setPalette(l);	
}

void MainWindow::set_background_color(QWidget *widget,QColor color)
{
	QPalette l(widget->palette());

	l.setColor(QColorGroup::Background,color);

	widget->setPalette(l);	
}

int MainWindow::slot_type(QListViewItem *si)
{
	int type = 0;

	if(si->parent())
	{
		type++;
	}
	else
	{
		return type;
	}
	
	if(si->parent()->parent())
	{
		type++;
	}
	else
	{
		return type;
	}
	
	if(si->parent()->parent()->parent())
	{
		type++;
	}
	else
	{
		return type;
	}

	if(si->parent()->parent()->parent()->parent())
	{
		type++;
	}
	else
	{
		return type;
	}

	return -1;
}

void MainWindow::make_connect_dialog()
{
	//debug("make connect dialog.");

	dialog = new Connect(this);

	connect((const QObject *)dialog->fire,SIGNAL(clicked()),(const QObject *)this,SLOT(slot_fire()));

	connect((const QObject *)dialog->close,SIGNAL(clicked()),(const QObject *)this,SLOT(slot_close()));

	load_server_list(dialog);

	dialog->setCaption(tr("MySQL Navigator"));	

	dialog->host->setSelection(0, dialog->host->text().length());

	((QWidget *)dialog)->close();
}
