#include <qfile.h>
#include <stdlib.h>
#include <qlineedit.h>
#include "mainwindow.h"

void MainWindow::load_history()
{
	char buffer[255];
	int si;

	sprintf(buffer, "%s/%s", getenv("HOME"), ".mysqlnavigator.history");

	QFile history(buffer);

	/*
	if(QFile::exists(buffer) == FALSE)
	{
		sprintf(buffer, "touch %s/%s", getenv("HOME"), HISTORY);
		
		si = system(buffer);

		if(si == 127 || si == -1)
		{
			//debug("system() system call fail.");
			return;
		}
	}
	*/

	if(history.open(IO_ReadOnly) == FALSE)
	{
		//debug("open() system call fail.");
		return;
	}

	while((si = history.readLine(buffer, sizeof(buffer))))
	{
		if(si == -1)
		{
			break;
		}	
		
		query->insertItem(buffer);
	}
	
	query->lineEdit()->setText("");
	
	history.close();	
}

void MainWindow::save_history()
{
	char buffer[255];

	QString sql;

	sprintf(buffer, "%s/%s", getenv("HOME"), ".mysqlnavigator.history");  

	QFile history(buffer);

	if(history.open(IO_WriteOnly) == FALSE)
		return;

	for(int l = 0; l < query->count(); l++)
			sql += query->text(l).local8Bit().simplifyWhiteSpace() + "\n";

	history.writeBlock(sql.latin1(), sql.length());

	history.close();
}

void MainWindow::clear_history()
{
	query->clear();

	int si;

	char buffer[255];

	sprintf(buffer, "rm -rf %s/%s", getenv("HOME"), ".mysqlnavigator.history");

	si = system(buffer);

	if(si == 127 || si == -1)
	{
		//debug("system() system call fail.");
	}
}
