#include <qmenubar.h>
#include <qmessagebox.h>

#include "mainwindow.h"
#include "mdiwindow.h"
#include "flush.h"

void MainWindow::slot_flush_threads()
{
	if(mysql_query(&mysql,"flush threads"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error();
    }  
}

void MainWindow::slot_flush_hosts()
{
	if(mysql_query(&mysql,"flush hosts"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error();
    }  
}

void MainWindow::slot_flush_logs()
{
	if(mysql_query(&mysql,"flush logs"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error();
    }  
}

void MainWindow::slot_flush_privilages()
{
	if(mysql_query(&mysql,"flush privileges"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error();
    }  
}

void MainWindow::slot_flush_status()
{
	if(mysql_query(&mysql,"flush status"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error();
    }  
}

void MainWindow::slot_flush_tables()
{
	if(mysql_query(&mysql,"flush tables"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&mysql)));
		slot_error();
    }  
}

void MainWindow::slot_flush()
{
	if(!flag)
	{
		return;	
	}
		
	MDIWindow* si = new MDIWindow(work_space, 0, WDestructiveClose);

	si->setFixedSize(263,435);
	
	Flush *flush = new Flush(&mysql,si);
	
	connect(flush, SIGNAL(signal_error()), this, SLOT(slot_error()));

    si->setCentralWidget(flush);
			 
    si->setCaption(tr("Flush"));

	si->setFixedSize(200, 216 + 25);

	QPopupMenu *l = new QPopupMenu();
	l->insertItem(tr("&Fire"), flush, SLOT(slot_fire()), CTRL+Key_F);
	l->insertSeparator();
	l->insertItem(tr("&Close"), flush, SLOT(slot_close()), CTRL+Key_C);
	si->menuBar()->insertItem(tr("&File"), l);
	
	l = new QPopupMenu();
	l->insertItem(tr("&About..."), flush, SLOT(slot_about()), Key_F1);
	si->menuBar()->insertItem(tr("&Help"), l);

	si->show();
}
