#include <qmessagebox.h>
#include <qmenubar.h>
#include <qstatusbar.h>
#include <stdio.h>
#include "mainwindow.h"
#include "mdiwindow.h"
#include "query.h"
#include "multilinelistviewitem.h"
#include "querylistview.h"

void MainWindow::slot_query()
{
	slot_query(database->currentText(), query->currentText());
}

void MainWindow::slot_query(const QString &database, const QString &query)
{
	slot_query(database, query, "");
}

void MainWindow::slot_query(const QString &database, const QString &query, const QString &title)
{
	MDIWindow* si_ = new MDIWindow(work_space, 0, WDestructiveClose);
  
	if(title.length() == 0)
	{
		si_->setCaption(tr("Query") + QString(" - ") + query);
	}
	else
	{
		si_->setCaption(title + QString(" - ") + query);
	}

	QueryListView *sql = new QueryListView(&mysql, &global, si_);

	connect(sql, SIGNAL(signal_error()), this, SLOT(slot_error()));

	sql->set_sql(database, query);

	switch(sql->execute())
	{
		case SQL_ERROR:
			return;
		case SQL_SCHEMA:
			slot_schema();
			return;
		case SQL_NOSCHEMA:
			return;
	}

	 if(is_exist_in_history(query) == FALSE)
     {
         QString sql = this->query->currentText();
         this->query->insertItem(query);
         this->query->lineEdit()->setText(sql);
     }

	si_->statusBar()->message("Fields: " + QString::number(sql->get_field_number()) + ", Records: " + QString::number(sql->get_record_number()));

	//debug("sql simple");

	si_->setCentralWidget(sql);

	if(sql->sizeHint().width() + 5 > work_space->width())
	{
		if(sql->sizeHint().height() > 200)
		{
			si_->resize(work_space->width() - 350, 200);
		}
		else
		{
			si_->resize(work_space->width() - 350, sql->sizeHint().height());
		}
	}
	else
	{
		if(sql->sizeHint().height() > 200)
		{
			si_->resize(sql->sizeHint().width() + 5, 200);
		}
		else
		{
			si_->resize(sql->sizeHint().width() + 5, sql->sizeHint().height());
		}
	}

	//slot_schema();

	QPopupMenu *l = new QPopupMenu();
	l->insertItem(tr("&Save"), sql, SLOT(slot_save()), CTRL+Key_S);
	l->insertSeparator();
	l->insertItem(tr("&Close"), sql, SLOT(slot_close()), CTRL+Key_C);
	si_->menuBar()->insertItem(tr("&File"), l);
	
	l = new QPopupMenu();
	l->insertItem(tr("&About..."), sql, SLOT(slot_about()), Key_F1);
	si_->menuBar()->insertItem(tr("&Help"), l);

	si_->show();
}

void MainWindow::slot_query_window()
{
	if(!flag)
	{
		return;	
	}
	
	MDIWindow* l = new MDIWindow(work_space, 0, WDestructiveClose);
	
	Query *query = new Query(&mysql, &global, l);
	
	connect(query, SIGNAL(signal_query(const QString &, const QString &)), this, SLOT(slot_query(const QString &, const QString &)));

	connect(query, SIGNAL(signal_schema()), this, SLOT(slot_schema()));
	connect(this, SIGNAL(signal_schema()), query, SLOT(slot_database()));

    l->setCentralWidget(query);

	l->setCaption(tr("Query"));
   
	//
	QPopupMenu *l_ = new QPopupMenu();
	l_->insertItem(tr("&Fire"), query, SLOT(slot_fire()), CTRL+Key_F);
	l_->insertItem(tr("&Save"), query->query, SLOT(slot_save()), CTRL+Key_S);
	l_->insertSeparator();
	l_->insertItem(tr("&Close"), query, SLOT(slot_close()), CTRL+Key_C);
	l->menuBar()->insertItem(tr("&File"), l_);

	l_ = new QPopupMenu();
	l_->insertItem(tr("&Undo"), query, SLOT(slot_undo()));
	l_->insertItem(tr("&Redo"), query, SLOT(slot_redo()));
	l_->insertSeparator();
	l_->insertItem(tr("&Cut"), query, SLOT(slot_cut()));
	l_->insertItem(tr("C&opy"), query, SLOT(slot_copy()));
	l_->insertItem(tr("&Paste"), query, SLOT(slot_paste()));
	l_->insertItem(tr("C&lear"), query, SLOT(slot_clear()));
	l_->insertItem(tr("Select &All"), query, SLOT(slot_select_all()));
	l->menuBar()->insertItem(tr("&Edit"), l_);

	l_ = new QPopupMenu();
	l_->insertItem(tr("&About..."), query, SLOT(slot_about()), Key_F1);
	l->menuBar()->insertItem(tr("&Help"), l_);

	l->resize(400, 250); 
	l->show();
}

bool MainWindow::is_exist_in_history(const QString &sql)
{
	for(int l = 0; l < query->count(); l++)
		if(query->text(l) == sql)
			return TRUE;

	return FALSE;
}
