#include "password.h"

#include <qmessagebox.h>
#include <qcombobox.h>
#include <qlineedit.h>

void Password::slot_fire()
{
	QString sql;

	if(password->text().isEmpty())
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Please enter password."));
		return;
	}

	if(again->text().isEmpty())
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Please enter password again."));
		return;
	}

	if(password->text() != again->text())
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Please enter password correctly."));
		return;
	}

	sql += "update user set password = password('";
	sql += password->text();
	sql += "')";
	sql += " where host = '";
	sql += host->currentText();
	sql += "'";
	sql += " && ";
	sql += "user = '";
	sql += user->currentText();
	sql += "'";

	if(mysql_select_db(mysql, "mysql"))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
		emit signal_error();	
		return;
	}

	if(mysql_query(mysql, sql.latin1()))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
		emit signal_error();	
		return;
	}

	mysql_reload(mysql);

	QMessageBox::information(this, tr("MySQL Navigator"), tr("Password has been successfully modified."));
}

void Password::slot_close()
{
	parentWidget()->close();
}

void Password::slot_about()
{
	QMessageBox::information(this, tr("MySQL Navigator"), tr("This is a password window."));
}

void Password::slot_host()
{
	QString sql;

	MYSQL_RES *result;
	MYSQL_ROW row;

	sql += "select distinct host from user";

	host->clear();

	if(mysql_select_db(mysql, "mysql"))
		return;

	if(mysql_query(mysql, sql.latin1()))
		return;

	result = mysql_store_result(mysql);

	if(result == NULL)
		return;

	while((row = mysql_fetch_row(result)))
		host->insertItem(row[0]);

	mysql_free_result(result);
}

void Password::slot_user()
{
	QString sql;
	QString host;

	MYSQL_RES *result;
	MYSQL_ROW row;
	
	host = this->host->currentText();

	sql += "select user from user where host = '";
	sql += host;
	sql += "'";

	user->clear();

	if(mysql_select_db(mysql, "mysql"))
		return;

	if(mysql_query(mysql, sql.latin1()))
		return;

	result = mysql_store_result(mysql);

	if(result == NULL)
		return;

	while((row = mysql_fetch_row(result)))
		user->insertItem(row[0]);
	
	mysql_free_result(result);
}
