#include <qpixmap.h>
#include "schema.h"
#include "db.xpm"

void Schema::slot_expand(QListViewItem *data)
{
	if(data->parent() == NULL)
		return;

	if(data->parent()->parent() == NULL)
	{
		database.replace(data->text(0), TRUE);
	}
	else if(data->parent()->parent()->parent() == NULL)
	{
		table.replace(data->text(0), TRUE);
	}
}

void Schema::slot_collapse(QListViewItem *data)
{
	if(data->parent() == NULL)
		return;
	
	if(data->parent()->parent() == NULL)
	{
		database.replace(data->text(0), FALSE);
	}
	else if(data->parent()->parent()->parent() == NULL)
	{
		table.replace(data->text(0), FALSE);
	}
}

void Schema::slot_schema()
{
	clear();

	MYSQL_RES *result;

	MYSQL_ROW row;
	
	QListViewItem *host=new QListViewItem(this, QString(user)+QString("@")+QString(this->host));

	QListViewItem *database;

	result = mysql_list_dbs(mysql,NULL);

	if(result == NULL)
	{
		debug("mysql_list_dbs failed");
		return ;
	}

	database = NULL;

	while((row = mysql_fetch_row(result)))
	{
		database = new QListViewItem(host, database, row[0]);
		database->setPixmap(0, QPixmap(db_xpm));
		set_table(database);
	}
	mysql_free_result(result);

	setOpen(host,TRUE);
}
