#include <qmessagebox.h>
#include <qfiledialog.h>
#include <qfile.h>
#include <qheader.h>
#include <qpopupmenu.h>
#include <qmultilineedit.h>

#include "querylistview.h"
#include "multilinelistviewitem.h"
#include "xuery.h"

QueryListView::QueryListView(MYSQL *mysql, struct __global__ *global, QWidget *parent)
	: QListView(parent)
{
	this->mysql = mysql;

	this->global = global;

	setAllColumnsShowFocus(TRUE);

	signal_connect();
}

QueryListView::~QueryListView()
{
}

void QueryListView::signal_connect()
{
	connect(this, SIGNAL(rightButtonClicked ( QListViewItem *, const QPoint &, int )), this, SLOT(slot_click(QListViewItem *, const QPoint &, int)));
}

void QueryListView::slot_click(QListViewItem *row, const QPoint &, int)
{
	if(is_simple_query() == FALSE)
		return;
	
	dummy = row;

	QPopupMenu *l = new QPopupMenu();

	if(row == NULL)
	{
		l->insertItem(tr("Insert record"), this, SLOT(slot_insert(int)));
		l->insertItem(tr("Refresh record"), this, SLOT(slot_refresh(int)));
	}
	else
	{
		l->insertItem(tr("Delete record"), this, SLOT(slot_delete(int)));
		l->insertItem(tr("Update record"), this, SLOT(slot_update(int)));
		l->insertItem(tr("Insert record"), this, SLOT(slot_insert(int)));
		l->insertItem(tr("Refresh record"), this, SLOT(slot_refresh(int)));
	}		

	l->popup(QCursor::pos());
}

void QueryListView::set_sql(const QString &database, const QString &sql, const QString &)
{
	this->sql = sql;
	this->database = database;
	this->table = table_name();
}

int QueryListView::execute()
{
	field_number = 0;
	record_number = 0;

	type.clear();

	int l;

	l = columns();

	for(int i = l - 1; i >=0; i--)
	{
		removeColumn(i);
	}

	clear();

	MultiLineListViewItem *si;

    setRootIsDecorated(FALSE);
	
	if(database.length() == 0)
	{
	}
	else
	{
		mysql_select_db(mysql,database.latin1());
	}

	if((mysql_query(mysql, sql.latin1())))
	{
		emit signal_error();
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
	
		return SQL_ERROR; 	 
	}

	result = mysql_store_result(mysql);
	
	if(result == NULL)
	{
		sql = sql.upper();

		if(sql.contains("CREATE") || sql.contains("DROP") || sql.contains("ALTER") || sql.contains("RENAME"))
			return SQL_SCHEMA;
		else
			return SQL_NOSCHEMA;
	}

	while((field = mysql_fetch_field(result)))
	{
		type.insert(field_number, field->type); 
		field_number ++;
		addColumn(field->name);
	}

	flag = FALSE;
	disconnect(header(), SIGNAL(clicked(int)), this, SLOT(slot_sort(int)));	
	connect(header(), SIGNAL(clicked(int)), this, SLOT(slot_sort(int)));
	setSorting(-1);

	while((row = mysql_fetch_row(result)))
	{
		record_number ++;
	
		unsigned long *length = mysql_fetch_lengths(result);

		si = new MultiLineListViewItem(this, get_last());
	
		for(unsigned int l = 0; l < mysql_num_fields(result); l++)
		{
			if(global->query.flag)
			{
				char *escape_string = new char[length[l] * 2 + 1];
				mysql_real_escape_string(mysql, escape_string, row[l], length[l]);
				si->setText(l, QString::fromLocal8Bit(escape_string));
				delete escape_string;
			}
			else
				si->setText(l, QString::fromLocal8Bit(row[l]));
		}

		slot_row_height(si);
	}

	mysql_free_result(result);

	return SQL_SIMPLE;
}

void QueryListView::slot_row_height(QListViewItem *si)
{
	int height = 1;

	int column = si->listView()->columns();

	for(int l = 0; l < column; l++)
	{
		int si_ = newline_number(si->text(l));

		if(si_ > height)
		{
			height = si_;
		}
	}

	((MultiLineListViewItem *)si)->set_height(18 * height);
}

int QueryListView::newline_number(const QString &string)
{
	int l = string.length();

	int total = 0;

	for(int si = 0; si < l; si++)
	{
		if(string[si] == '\n')
		{
			total++;
		}
	}

	return ++total;
}

void QueryListView::slot_clear()
{
	int l;

	l = columns();

	for(int i = l - 1; i >=0; i--)
	{
		removeColumn(i);
	}

	clear();
}

void QueryListView::slot_save()
{
	QString name = QFileDialog::getSaveFileName("", QString::null, this);
	if(name.isEmpty()) 
	{
		return;
    } 

	if(QFile::exists(name))
	{
		int l = QMessageBox::warning (this, tr("MySQL Navigator"), tr("File already exists.\nDo you want to overwrite it?"), tr("Yes"), tr("No"));
		
		if(l == 1)
		{
			return;
		}
	}

	QString buffer;

	QFile sql(name);

	if(sql.open(IO_WriteOnly) == FALSE)
	{
		//debug("open failed");
		return;
	}

	buffer += "# Query result dump utility version 0.0.3\n";
	buffer += "# [DATABASE]\n";
	buffer += "# ";
	buffer += this->database;
	buffer += "\n";
	buffer += "# [SQL]\n";
	buffer += "# ";
	buffer += this->sql;
	buffer += "\n";
	buffer += "# [FIELD]\n";
	buffer += "# ";

	int column = columns();

	for(int i = 0; i < column; i++)
	{
		buffer += header()->label(i);
		buffer += "\t";
	}
	buffer += "\n";

	QListViewItemIterator l(this);

	buffer += "# [DATA]\n";
	buffer += "# Field is separated by tab character.";
	buffer += "\n";

	for(; l.current(); ++l)
	{
		for(int i = 0; i < column; i++)
		{
			if(l.current()->text(i).isEmpty())
			{
				buffer += "NULL";
			}
			else
			{
				char *escape_string;
				escape_string = new char[l.current()->text(i).local8Bit().length() * 2 + 1];
			 	mysql_real_escape_string(mysql, escape_string, l.current()->text(i).local8Bit(), l.current()->text(i).local8Bit().length());
			 
				buffer += QString(escape_string);
				delete escape_string;
			}
			buffer += "\t";
		}
		buffer += "\n";
	}

	//debug(buffer.latin1());

	sql.writeBlock(buffer.latin1(), buffer.length());

	sql.close();

	QMessageBox::information(this, tr("MySQL Navigator"), tr("Query results are successfully saved to ") + name);
}

void QueryListView::slot_close()
{
	parentWidget()->close();
}

void QueryListView::slot_about()
{
	QMessageBox::information(this, tr("MySQL Navigator"), tr("Query result window version 0.0.1.\n"));
}

void QueryListView::slot_sort(int l)
{
	if(flag)
	{
		setSorting(l, flag);
		flag = FALSE;
	}
	else
	{
		setSorting(l, flag);
		flag = TRUE;
	}
}

QListViewItem *QueryListView::get_last()
{
	QListViewItem *l;
	QListViewItem *last;

	l = firstChild();

	if(l == NULL)
	{
		return NULL;
	}

	last = l;
	
	while(TRUE)
	{
		l = l->itemBelow();

		if(l == NULL)
		{
			break;
		}

		last = l;
	}

	return last;
}

void QueryListView::slot_insert(int)
{
	QString sql;

	sql += "INSERT INTO ";
	sql += table;
	sql += "\n";
	sql += "(";

	for(unsigned int l = 0; l < type.count(); l++)
	{
		sql += "\n";

		sql += header()->label(l);

		if(l != type.count() - 1)
			sql += ", ";
	}

	sql += "\n";
	sql += ")";
	sql += "\n";
	sql += "VALUES";
	sql += "\n";
	sql += "(";

	for(unsigned int l = 0; l < type.count(); l++)
	{
		sql += "\n";
		
		if(IS_NUM(type[l]))
			sql += "";
		else
		{
			sql += "\"";
			sql += "";
			sql += "\"";
		}

		if(l != type.count() - 1)
			sql += ", ";
	}

	sql += "\n";
	sql += ")";

	Xuery *xuery = new Xuery(mysql);

	connect(xuery, SIGNAL(signal_sql_success()), this, SLOT(slot_sql_success()));
	xuery->database = database;
	xuery->query->setText(QString::fromLocal8Bit(sql));

	xuery->setCaption(tr("Query - insert record"));

	xuery->resize(250, 400);

	xuery->show();
}

void QueryListView::slot_update(int)
{
	QString sql;

	sql += "UPDATE ";
	sql += table;
	sql += " SET ";

	for(unsigned int l = 0; l < type.count(); l++)
	{
		sql += "\n";

		sql += header()->label(l);
		sql += " = ";

		if(IS_NUM(type[l]))
		{
		}
		else
		{
			sql += "\"";
			sql += "";	
			sql += "\"";
		}

		if(l != type.count() - 1)
			sql += ", ";
	}

	sql += "\n";

	sql += "WHERE";
	
	for(unsigned int l = 0; l < type.count(); l++)
	{
		sql += "\n";
		
		if(IS_NUM(type[l]))
		{
			sql += header()->label(l);
			sql += " = ";
			sql += dummy->text(l);

			if(l != type.count() - 1)
			{
				sql += " && ";
			}
		}
		else
		{
			sql += header()->label(l);
			sql += " = ";
			sql += "\"";	
			sql += dummy->text(l).local8Bit();
			sql += "\"";	

			if(l != type.count() - 1)
			{
				sql += " && ";
			}
		}
	}

	Xuery *xuery = new Xuery(mysql);
	
	xuery->setCaption(tr("Query - update record"));
	
	connect(xuery, SIGNAL(signal_sql_success()), this, SLOT(slot_sql_success()));

	xuery->database = database;
	xuery->query->setText(QString::fromLocal8Bit(sql));

	xuery->resize(250, 400);

	xuery->show();
}

void QueryListView::slot_delete(int)
{
	QString sql;

	if(table.isEmpty())
		return;

	sql += "DELETE FROM ";
	sql += table;
	sql += " WHERE ";

	for(unsigned int l = 0; l < type.count(); l++)
	{
		if(IS_NUM(type[l]))
		{
			sql += header()->label(l);
			sql += " = ";
			sql += dummy->text(l);

			if(l != type.count() - 1)
			{
				sql += " && ";
			}
		}
		else
		{
			sql += header()->label(l);
			sql += " = ";
			sql += "\"";	
			sql += dummy->text(l).local8Bit();
			sql += "\"";	

			if(l != type.count() - 1)
			{
				sql += " && ";
			}
		}
	}

	int l = QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you really want to delete this record ?"), tr("Yes"), tr("No"));
		
	if(l == 1)
	{
		return;
	}

	if(mysql_select_db(mysql, database.latin1()))
		return;
	
	if(mysql_query(mysql, sql.latin1()))
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
	else
		execute();
}

QString QueryListView::table_name()
{
	bool flag = FALSE;

	QString table;

	QString query = this->sql;

	query = query.simplifyWhiteSpace();
	if(query[query.length() - 1] == ';')
		query = query.left(query.length() - 1);	

	for(unsigned int l = 0; l < query.length(); l++)
	{
		if(flag)
		{
			table += QChar(query[l]);
		}

		if((query[l] == 'F' || query[l] == 'f') && (query[l + 1] == 'R' || query[l + 1] == 'r') && (query[l + 2] == 'O' || query[l + 2] == 'o') && (query[l + 3] == 'M' || query[l + 3] == 'm'))
		{
			l += 4;
			flag = TRUE;
			continue;
		}

		if(flag)
			if(query[l] == ' ')
			{
				flag = FALSE;
				break;
			}

	}

	//debug("table: %s", table.latin1());

	return table.stripWhiteSpace();
}

bool QueryListView::is_simple_query()
{
	QString sql = this->sql;

	sql = sql.upper();
	
	sql = sql.stripWhiteSpace();

	if(sql[0] == 'S' && sql[1] == 'E' && sql[2] == 'L' && sql[3] == 'E' && sql[4] == 'C' && sql[5] == 'T')
		return TRUE;
	else
		return FALSE;
}

void QueryListView::slot_sql_success()
{
	execute();
}

void QueryListView::slot_refresh(int)
{
	execute();
}
