#include "serverlistviewitem.h"

ServerListViewItem::ServerListViewItem(QListView *parent, QListViewItem *dummy, QString title, const QString &host, const QString &user, const QString &password, const QString &database, const QString &port, const QString &socket)
	: QListViewItem(parent, dummy, title)
{
	this->host = host;
	this->user = user;
	this->password = password;
	this->database = database;
	this->port = port;
	this->socket = socket;
}

ServerListViewItem::~ServerListViewItem()
{
}

void ServerListViewItem::paintCell(QPainter *l,const QColorGroup &color,int column,int width,int alignment)
{
	QListViewItem::paintCell(l,color,column,width,alignment );

	 int x = width - 1;
	 int y = height() - 1;

	 l->setPen(Qt::black);
	 l->setPen(QPen(QColor(210,210,210),1));
	 l->drawLine(0, 0, 0, height());         
	 l->drawLine(0, y, x, y);
}
