#include "xonfigure.h"

#include <qfiledialog.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qpushbutton.h>

void Xonfigure::slot_fire()
{
	slot_apply();

	parentWidget()->close();
}

void Xonfigure::slot_apply()
{
	global->log.flag = log_flag->isChecked();
	global->log.file = log_file->text();

	global->schema.flag = schema_flag->isChecked();
	global->password.flag = password_flag->isChecked();

	global->query.flag = escape_flag->isChecked();
	
	global->background.flag = background_flag->isChecked();
	global->background.file = background_file->text();
	
	global->limit = limit->text().toInt();	

	emit signal_display_background();
}


void Xonfigure::slot_close()
{
	parentWidget()->close();
}

void Xonfigure::slot_log_file()
{
	QString l = QFileDialog::getOpenFileName(QString::null, "*.*", this);

	if(!l.isEmpty())
	{
		log_file->setText(l);
	}
}

void Xonfigure::slot_background_file()
{
	QString l = QFileDialog::getOpenFileName(QString::null, "*.*", this);

	if(!l.isEmpty())
	{
		background_file->setText(l);
	}
}

void Xonfigure::slot_log_flag()
{
	if(log_flag->isChecked())
	{
		log_file->setEnabled(TRUE);
		log_button->setEnabled(TRUE);
	}
	else
	{
		log_file->setEnabled(FALSE);
		log_button->setEnabled(FALSE);
	}
}

void Xonfigure::slot_background_flag()
{
	if(background_flag->isChecked())
	{
		background_file->setEnabled(TRUE);
		background_button->setEnabled(TRUE);
	}
	else
	{
		background_file->setEnabled(FALSE);
		background_button->setEnabled(FALSE);
	}
}

void Xonfigure::slot_password_flag()
{
}

void Xonfigure::slot_schema_flag()
{
}
