#include "server.h"
#include "servernew.h"
#include <qpopupmenu.h>
#include <qlistview.h>
#include <qmessagebox.h>
#include <qfiledialog.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qstatusbar.h>
#include <qspinbox.h>
#include <qcursor.h>
#include <qregexp.h>
#include <stdlib.h>
#include "database.xpm"

void Server::slot_server(QListViewItem *v, const QPoint &, int)
{
	if(v == NULL)
		return;

	QPopupMenu *z;

	if(v->parent() == NULL)
	{

		z = new QPopupMenu;
		z->insertItem(tr("&New"), this, SLOT(slot_server_new(int)));

		z->popup(QCursor::pos());

		hay = v;
	}
	else
	{
		z = new QPopupMenu;
		z->insertItem(tr("&Open"), this, SLOT(slot_server_open(int)));
		z->insertSeparator();	
		z->insertItem(tr("&Modify"), this, SLOT(slot_server_modify(int)));
		z->insertItem(tr("&Delete"), this, SLOT(slot_server_delete(int)));

		z->popup(QCursor::pos());

		hay = v;
	}
}

void Server::slot_server_new(int)
{
	ServerNew *server = new ServerNew(this, 0, TRUE);

	server->setCaption(tr("New Server"));

	server->exec();

	if(server->flag)
	{
		QListViewItemIterator sql(this->server);

		for(; sql.current(); sql++)
		{
			if(sql.current()->text(0) == server->user->text() + "@" + server->host->text())
			{
				QMessageBox::critical(this, tr("MySQL Navigator"), sql.current()->text(0) + tr(" already exists"));
				return;
			}
		}

		struct server_data v;

		v.user = server->user->text();
		v.password = server->password->text();
		v.database = server->database->text();
		v.port = server->port->text();
		v.socket = server->socket->text();
		v.timeout = server->timeout->text();
	
		((MainWindow *)qApp->mainWidget())->server_map.insert(v.user + "@" + server->host->text(), v);
	
		QListViewItem *s = new QListViewItem(this->server->firstChild(), v.user + "@" + server->host->text());	
		s->setPixmap(0, QPixmap(database_xpm));
	}
	
	statusBar()->message(QString(tr(" Servers: ") + QString::number(this->server->firstChild()->childCount())));
}

void Server::slot_server_modify(int)
{
	hay = server->selectedItem();

	if(hay == NULL)
		return;

	if(hay == server->firstChild())
		return;

	struct server_data v = ((MainWindow *)qApp->mainWidget())->server_map.find(hay->text(0)).data();

	ServerNew *server = new ServerNew(this, 0, TRUE);
	
	server->setCaption(tr("Modify Server"));

	server->host->setText(hay->text(0).replace(QRegExp(".*@"), "" ));
	server->user->setText(v.user);
	server->password->setText(v.password);
	server->database->setText(v.database);
	server->port->setText(v.port);
	server->socket->setText(v.socket);
	server->timeout->setValue(v.timeout.toInt());

	server->exec();
	
	if(server->flag)
	{
		QListViewItemIterator sql(this->server);

		for(; sql.current(); sql++)
		{
			if(sql.current() == hay)
				continue;

			if(sql.current()->text(0) == server->user->text() + "@" + server->host->text())
			{
				QMessageBox::critical(this, tr("MySQL Navigator"), sql.current()->text(0) + tr(" already exists"));
				return;
			}
		}

		struct server_data v;

		v.user = server->user->text();
		v.password = server->password->text();
		v.database = server->database->text();
		v.port = server->port->text();
		v.socket = server->socket->text();
		v.timeout = server->timeout->text();

		((MainWindow *)qApp->mainWidget())->server_map.remove(hay->text(0));
		((MainWindow *)qApp->mainWidget())->server_map.insert(v.user + "@" + server->host->text(), v);
	
		hay->setText(0, v.user + "@" + server->host->text());	
	}
}

void Server::slot_server_delete(int)
{
	hay = server->selectedItem();

	if(hay == NULL)
		return;

	if(hay == server->firstChild())
		return;

	if(QMessageBox::warning (this, tr("MySQL Navigator"), tr("Do you want to delete ") + hay->text(0) + " server ?", tr("Yes"), tr("No")) == 1)
		return;

	((MainWindow *)qApp->mainWidget())->server_map.remove(hay->text(0));

	delete hay;
	
	statusBar()->message(QString(tr(" Servers: ") + QString::number(this->server->firstChild()->childCount())));
}

void Server::slot_server_open()
{
	slot_server_open(TRUE);
}

void Server::slot_server_open(int)
{
	hay = server->selectedItem();

	if(hay == NULL)
		return;

	if(hay == server->firstChild())
		return;

	struct server_data v = ((MainWindow *)qApp->mainWidget())->server_map.find(hay->text(0)).data();

	if(flag)
	{
		QString sql;

#ifdef WIN32
		sql += "mysqlnavigator.exe ";
#else
		sql += "mysqlnavigator ";
#endif

		sql += "-h " + hay->text(0).replace(QRegExp(".*@"), "" ) + " ";

		sql += "-u " + v.user + " ";				

		if(v.password.isEmpty() == FALSE)
			sql += "-p " + v.password + " ";				

		if(v.database.isEmpty() == FALSE)
			sql += "-d " + v.database + " ";				

		if(v.port.isEmpty() == FALSE)
			sql += "-P " + v.port + " ";				

		if(v.socket.isEmpty() == FALSE)
			sql += "-s " + v.socket + " ";				

		if(v.timeout.isEmpty() == FALSE)
			sql += "-t " + v.timeout + " ";				

#ifdef WIN32
		::WinExec(sql.latin1(), SW_SHOW);
#else
		sql += "&";
		system(sql.latin1());
#endif
	
		QMainWindow::close();

		return;
	}	
	
	if(!mysql_real_connect(&((MainWindow *)qApp->mainWidget())->mysql,
							hay->text(0).replace(QRegExp(".*@"), "" ).latin1(),
							v.user.latin1(),
							v.password.latin1(),
							v.database.length()==0?NULL:v.database.latin1(),
							v.port.length()==0?3306:v.port.toUInt(),
							v.socket.length()==0?NULL:v.socket.latin1(),
							0	
							))
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&((MainWindow *)qApp->mainWidget())->mysql)));
	}
	else
	{
		emit signal_server(hay->text(0), v.user);

		QMainWindow::close();
	}
}

bool Server::initialize()
{
	QPopupMenu *z;

	z = new QPopupMenu;
	z->insertItem(tr("&New"), this, SLOT(slot_server_new(int)), CTRL+Key_N);
	z->insertItem(tr("&Open"), this, SLOT(slot_server_open(int)), CTRL+Key_O);
	z->insertSeparator();	
	z->insertItem(tr("Cl&ose"), this, SLOT(slot_close()));
	
	menuBar()->insertItem(tr("&File"),z);
	
	z = new QPopupMenu;
	z->insertItem(tr("&Modify"), this, SLOT(slot_server_modify(int)));
	z->insertItem(tr("&Delete"), this, SLOT(slot_server_delete(int)));
	menuBar()->insertItem(tr("&Tools"), z);
	
	//z = new QPopupMenu;
	//z->insertItem(tr("&About..."), this, SLOT(slot_about()), Key_F1);
	//menuBar()->insertItem(tr("&Help"), z);

	statusBar();

	QMap<QString, struct server_data>::Iterator server;

	for(server = ((MainWindow *)qApp->mainWidget())->server_map.begin(); server != ((MainWindow *)qApp->mainWidget())->server_map.end(); server++)
	{
		QListViewItem *s = new QListViewItem(this->server->firstChild(), server.key());	
		s->setPixmap(0, QPixmap(database_xpm));
	}

	statusBar()->message(QString(tr(" Servers: ") + QString::number(this->server->firstChild()->childCount())));
	
	return TRUE;
}

void Server::slot_about()
{
	QMessageBox::information(this, tr("MySQL Navigator"), "This is Server"); 
}

void Server::slot_close()
{
	QMainWindow::close();
}
