.\" $NCDId: @(#)AuListB.man,v 1.1 1994/09/27 00:30:05 greg Exp $
.\" copyright 1994 Steven King
.\"
.\" portions are
.\" * Copyright 1993 Network Computing Devices, Inc.
.\" *
.\" * Permission to use, copy, modify, distribute, and sell this software and its
.\" * documentation for any purpose is hereby granted without fee, provided that
.\" * the above copyright notice appear in all copies and that both that
.\" * copyright notice and this permission notice appear in supporting
.\" * documentation, and that the name Network Computing Devices, Inc. not be
.\" * used in advertising or publicity pertaining to distribution of this
.\" * software without specific, written prior permission.
.\" * 
.\" * THIS SOFTWARE IS PROVIDED 'AS-IS'.  NETWORK COMPUTING DEVICES, INC.,
.\" * DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT
.\" * LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
.\" * PARTICULAR PURPOSE, OR NONINFRINGEMENT.  IN NO EVENT SHALL NETWORK
.\" * COMPUTING DEVICES, INC., BE LIABLE FOR ANY DAMAGES WHATSOEVER, INCLUDING
.\" * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS OF USE, DATA,
.\" * OR PROFITS, EVEN IF ADVISED OF THE POSSIBILITY THEREOF, AND REGARDLESS OF
.\" * WHETHER IN AN ACTION IN CONTRACT, TORT OR NEGLIGENCE, ARISING OUT OF OR IN
.\" * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" $Id: AuListB.man,v 1.1.1.1 1999/05/08 18:47:24 jon Exp $
.TH AuListBuckets 3 "1.2" "audiolib - bucket attributes"
.SH \fBName\fP
\fBAuListBuckets\fP \- list buckets
.SH \fBSynopsis\fP
#include <audio/audiolib.h>
.sp 1
\fBAuBucketAttributes\fP *\fBAuListBuckets\fP(\fIserver\fP, \fIvaluemask\fP, \fIattributes\fP, \fInbuckets\fP, \fIstatus\fP)
.br
    \fBAuServer\fP *\fIserver\fP;
.br
    \fBAuMask\fP \fIvaluemask\fP;
.br
    \fBAuBucketAttributes\fP *\fIattributes\fP;
.br
    int *\fInbuckets\fP; /* \fBRETURN\fP */
.br
    \fBAuStatus\fP *\fIstatus\fP; /* \fBRETURN\fP */
.SH \fBArguments\fP
.IP \fIserver\fP 1i
Specifies the connection to the audio server.
.IP \fIvaluemask\fP 1i
Specifies which bucket attributes are defined in \fIattributes\fP.
This must be a bitwise inclusive OR of zero or more of these constants: \fBAuCompCommonIDMask\fP, \fBAuCompCommonKindMask\fP, \fBAuCompCommonUseMask\fP, \fBAuCommonFormatMask\fP, \fBAuCommonNumTracksMask\fP, \fBAuCommonAccessMask\fP, \fPAuCommonDescriptionMask\fP, \fBAuCompBucketSampleRateMask\fP, or \fBAuCompBucketNumSamplesMask\fP.
If valuemask is zero, the attributes are ignored and are not referenced.
.IP \fIattributes\fP 1i
Specifies the structure from which the values (as specified by the value mask) are to be taken.
.IP \fInbuckets\fP 1i
Returns the number of buckets in the returned list.
.IP \fIstatus\fP 1i
If non-NULL, flush the output buffer and return the status from the server.
.SH \fBDescription\fP
\fBAuListBuckets\fP returns a list of buckets whose attributes match those values in \fIattributes\fP specified by \fIvaluemask\fP, or NULL, with \fInbuckets\fP set to 0, if there was an error.
Use \fBAuFreeBucketAttributes\fP to free the list when its nolonger needed.
.SH \fBErrors\fP
\fBAuBadLength\fP.
.SH \fBSee Also\fP
\fBAuGetBucketAttributes\fP.
.sp 1
audiolib \- \fBNetwork Audio System\fP C Language Interface
