#include <stdio.h>
#include <getopt.h>

#include "base.h"
#include "tree.h"
#include "proc.h"
#include "gui.h"
#include "ncps.h"

int main(int argc, char *argv[])
{
    int check = 1;
    int tmp;
    killer_t *chow;
    killer_t *hold;
    int c;
    int opt_a = 0, opt_t = 0, opt_u = 0;
    char user[20];
    char *homedir;
    char *path;

    int i;
   
    signal(SIGILL, cleanup);
    signal(SIGTERM, cleanup);
    signal(SIGSEGV, cleanup);
    signal(SIGABRT, cleanup);
    signal(SIGHUP, cleanup);

    /*  printf("initscr ended\n"); */

    killer.uid = getuid();

    for (;;) {
	static struct option long_options[] =
	{
	    {"all", 0, 0, 'a'},
	    {"user", 1, 0, 'u'},
	    {"tree", 0, 0, 't'},
	    {"help", 0, 0, 'h'},
	    {0, 0, 0, 0}
	};

	c = getopt_long(argc, argv, "atu:h", long_options, NULL);
	if (c == -1)
	    break;

	switch (c) {
	case 'a':
	    opt_a = 1;
	    break;

	case 't':
	    opt_t = 1;
	    break;

	case 'u':
	    opt_u = 1;
	    strncpy(user, optarg, 19);
	    break;

	case 'h':
	    printf("ncps: Screen oriented `ps'. Version %u.%u%s\n",
		   V_MAJOR, V_MINOR, V_PATCH);
	    usage();
	    exit(0);

	case '?':
	    usage();
	    exit(1);

	default:
	    printf("?? getopt returned character code 0%o ??\n", c);
	    exit(1);
	}
    }

    /* both -a and -u cannot be present */
    if (opt_a && opt_u) {
	fprintf(stderr, "ncps: Options 'all' and 'user' are mutually "
		"incompatible.\n");
	exit(1);
    }
    if (opt_a)
	killer.uid = -1;
    else if (opt_u) {
	struct passwd *p = getpwnam(user);
	if (p == NULL) {
	    fprintf(stderr, "ncps: No such user: %s\n", user);
	    exit(1);
	} else {
	    killer.uid = p->pw_uid;
	}
    } else {
	killer.uid = getuid();	/* default: current user */
    }


    t_view = opt_t;
	

#if !DEBUG
    initscr();

    check_scr_size();
    
    curs_set(0);
    keypad(stdscr, TRUE);
    cbreak();
    noecho();

    homedir = getenv ("HOME");
    path = (char *) malloc((strlen(homedir) + 9) * sizeof(char));
    sprintf(path, "%s/.ncpsrc", homedir);
    
    parse_rc_color(path, color_config);
    
    free(path);
    free(homedir);

    start_color();   
    
    init_pair(0, COLOR_WHITE, 
		COLOR_BLACK);
    
    for(i = 1; i < COLOR_OPTIONS; i++) {
      init_pair(i, color_config[i].foreground, 
		color_config[i].background);
    }    

  
#endif

   
    template_size = PT_SIZE;
    selection_template = (int *) malloc(template_size * sizeof(int));
    selection_template[0] = -1;
    
    initplist(killer.uid);

    chow = &killer;
    chow->t_count = 0;      
    make_tree(chow);

    /*  printf("initplist ended\n"); */

#if !DEBUG
    clear_all_screen();
#endif

    chow = &killer;
    while (check) {

	free(selection_template);
	refresh_stemplate(chow);
	
	/* printf("in main while loop\n"); */
	tmp = getchoice(chow);

	if (tmp == QUIT)
	    check = 0;
	else if (tmp == REINIT) {
	    endwin();
	    free_list(chow->pidlist, chow->count);
	    free_list(chow->trunk, chow->t_count);
	    free_branch(chow->ptree);
	    
	    initplist(killer.uid);
	    chow = &killer;
	    
	    chow->t_count = 0;
	    make_tree(chow);
	    
	    initscr();
	    curs_set(0);
	    clear_all_screen();
	} else if (tmp == LEFT) {
	    if (chow->mother) {
		free_list(chow->pidlist, chow->count);
		free_list(chow->trunk, chow->count);
		chow = chow->mother;
		free(chow->son);

	    }
	} else if (tmp == MONITOR) {

	    clear_all_screen();
	    endwin();
	    monitor(chow);
	    chow = chow->son;
	    selective_spew(chow);
	    /*  if(chow->count) {  */
/*              printf("%i %s\n", chow->count, chow->pidlist[0].pname); */
/*              getch(); */
/*          } */
	    initscr();
	    curs_set(0);
	    clear_all_screen();
	} else if (tmp == MONITOR_REFRESH) {
	    endwin();

	    hold = chow;
	    if (hold->count)
		selective_spew(hold);

	    while (hold->mother) {
		hold = hold->mother;
		if (hold->count)
		    selective_spew(hold);
	    }

	    /*  if(chow->count) {  */
/*              printf("%i %s\n", chow->count, chow->pidlist[0].pname); */
/*              getch(); */
/*          } */
	    initscr();
	    curs_set(0);
	    clear_all_screen();
	}
    }

    clear_all_screen();
    endwin();

    return 1;
}				/* main */

void cleanup(int nil)
{
    clear_all_screen();
    endwin();
    fprintf(stderr, "Terminated on signal %i.\n", nil);
    exit(0);
}


void usage(void)
{
    printf("Usage: ncps [options]\n"
	   "\t-a, --all                : display all processes\n"
           "\t-u <user>, --user <user> : display processes owned by <user>\n"
	   "\t                           (defaults to the current user)\n"
	   "\t-t --tree                : starts in tree mode\n "
	   "\t-h, --help               : display this help.\n");
}

void check_scr_size(void)
{
    if(COLS < MIN_WIDTH) {
	clear_all_screen();
	endwin();

	printf("error: terminal size too small\n");
	exit(0);
    }
}


			   


