#define yy_create_buffer ut_create_buffer
#define yy_delete_buffer ut_delete_buffer
#define yy_scan_buffer ut_scan_buffer
#define yy_scan_string ut_scan_string
#define yy_scan_bytes ut_scan_bytes
#define yy_flex_debug ut_flex_debug
#define yy_init_buffer ut_init_buffer
#define yy_flush_buffer ut_flush_buffer
#define yy_load_buffer_state ut_load_buffer_state
#define yy_switch_to_buffer ut_switch_to_buffer
#define yyin utin
#define yyleng utleng
#define yylex utlex
#define yyout utout
#define yyrestart utrestart
#define yytext uttext
#define yywrap utwrap

/* A lexical scanner generated by flex */

/* Scanner skeleton version:
 * $Header: /upc/share/CVS/udunits/lib/utscan.c,v 1.3 2003/08/29 18:37:47 steve Exp $
 */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5

#include <stdio.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#include <unistd.h>

/* Use prototypes in function declarations. */
#define YY_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define YY_USE_CONST
#define YY_USE_PROTOS
#endif

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define YY_BUF_SIZE 16384

typedef struct yy_buffer_state *YY_BUFFER_STATE;

extern int yyleng;
extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		yyless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the yyless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		*yy_cp = yy_hold_char; \
		yy_c_buf_p = yy_cp = yy_bp + n - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yytext_ptr )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */
typedef unsigned int yy_size_t;


struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2
	};

static YY_BUFFER_STATE yy_current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define YY_CURRENT_BUFFER yy_current_buffer


/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;

static int yy_n_chars;		/* number of characters read into yy_ch_buf */


int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart YY_PROTO(( FILE *input_file ));

void yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE yy_create_buffer YY_PROTO(( FILE *file, int size ));
void yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));
void yy_flush_buffer YY_PROTO(( YY_BUFFER_STATE b ));
#define YY_FLUSH_BUFFER yy_flush_buffer( yy_current_buffer )

YY_BUFFER_STATE yy_scan_buffer YY_PROTO(( char *base, yy_size_t size ));
YY_BUFFER_STATE yy_scan_string YY_PROTO(( yyconst char *str ));
YY_BUFFER_STATE yy_scan_bytes YY_PROTO(( yyconst char *bytes, int len ));

static void *yy_flex_alloc YY_PROTO(( yy_size_t ));
static void *yy_flex_realloc YY_PROTO(( void *, yy_size_t ));
static void yy_flex_free YY_PROTO(( void * ));

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (yy_current_buffer->yy_at_bol)

typedef unsigned char YY_CHAR;
FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;
typedef int yy_state_type;
extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state YY_PROTO(( void ));
static yy_state_type yy_try_NUL_trans YY_PROTO(( yy_state_type current_state ));
static int yy_get_next_buffer YY_PROTO(( void ));
static void yy_fatal_error YY_PROTO(( yyconst char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 20
#define YY_END_OF_BUFFER 21
static yyconst short int yy_accept[179] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,   21,   19,
        4,   20,    1,   15,   18,    4,   19,    4,    4,    3,
       16,    2,   15,   15,   15,   15,   15,   15,   15,    5,
       15,   15,   15,   15,   15,   19,    4,   16,   15,    8,
        8,    8,   19,    4,   13,   13,   13,   15,    4,    3,
        2,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    1,    5,   17,   16,    0,   17,    0,    3,    2,
        0,   15,   15,    0,   17,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   16,    0,   16,   15,    8,    8,
        8,    0,   16,   16,   16,   13,   13,   13,   13,   13,

       13,   15,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   17,    0,   17,   15,   15,   15,    3,    2,
       15,   15,   15,   15,    0,    0,    0,   16,    7,   10,
       10,   16,    8,    8,   13,   13,   14,   14,   12,   12,
       11,    0,    0,    0,    0,    0,    0,   15,   15,   15,
       15,    0,   16,    7,   10,    9,    0,   13,   14,   12,
       11,    0,    0,    0,    0,    0,    6,    6,    6,    9,
        8,    8,    8,    6,    6,    8,    8,    0
    } ;

static yyconst int yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    1,    4,    1,    5,    1,    1,    1,
        6,    7,    8,    1,    9,   10,   11,   12,   13,   14,
       15,   16,   16,   17,   18,   18,   18,   19,    1,    1,
        1,    1,    1,   20,   21,   22,   23,   22,   24,   25,
       22,   22,   26,   22,   22,   22,   27,   28,   29,   30,
       22,   31,   32,   33,   34,   22,   22,   22,   22,   22,
        1,    1,    1,   35,   36,    1,   37,   22,   38,   22,

       39,   40,   22,   22,   41,   22,   22,   22,   42,   43,
       44,   45,   22,   46,   47,   48,   22,   22,   49,   22,
       22,   22,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst int yy_meta[50] =
    {   0,
        1,    2,    3,    1,    1,    1,    1,    4,    5,    6,
        1,    7,    7,    7,    7,    7,    7,    7,    8,    1,
        9,    9,    9,   10,    9,    9,    9,    9,    9,    9,
        9,    9,   11,    9,    1,    9,    9,    9,   10,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9
    } ;

static yyconst short int yy_base[198] =
    {   0,
        0,    0,   42,    0,   49,   56,   78,    0,  548,  549,
      111,  549,    0,  549,  549,  539,   65,   78,   58,  543,
        0,  542,  147,   93,  165,  512,  515,  514,  511,  549,
      494,  487,  493,  491,  488,   90,   91,  110,  484,  182,
       60,  220,  250,    0,  288,   63,   97,  494,    0,  522,
      521,  497,  490,  494,  493,  488,  473,  466,  469,  468,
      465,    0,  549,   59,    0,   44,    0,  115,  503,  500,
      173,    0,  468,  195,  202,  469,  466,  471,  465,  444,
      443,  440,  445,  441,  116,  211,  128,  432,  478,  326,
      233,  238,  116,  125,  257,  364,  129,  156,  471,  131,

      240,  447,  433,  433,  430,  431,  427,  401,  402,  399,
      402,  398,  263,  270,  279,  301,  406,  399,  422,  421,
      399,  382,  377,  380,  307,  317,  393,  323,  399,  346,
      385,  347,  174,  332,  382,  371,  351,  370,  367,  362,
      361,  335,  331,  332,  296,  269,  272,  278,  284,  253,
      222,  379,  234,  239,  238,  229,  392,  203,  202,  201,
      200,  144,  142,  108,  114,  398,  335,  387,  365,  137,
      344,  415,  350,  126,  119,  101,   82,  549,  427,  433,
      437,  441,  447,  453,  460,  464,  465,  472,  481,  484,
      493,  502,  509,  518,  524,  534,  540

    } ;

static yyconst short int yy_def[198] =
    {   0,
      178,    1,    1,    3,    1,    1,    1,    7,  178,  178,
      178,  178,  179,  178,  178,  178,  180,  180,  181,  178,
       18,  178,  182,  182,  182,   24,   24,   24,   24,  178,
       24,   24,   24,   24,   24,  183,  183,  184,   24,  178,
       40,  178,  178,   43,  178,   45,   18,   24,   11,  178,
      178,  178,  178,  178,  178,  178,  178,  178,  178,  178,
      178,  179,  178,  181,   18,  185,   64,  186,  178,  178,
      187,   24,   24,  178,  187,   24,   24,   24,   24,   24,
       24,   24,   24,   24,  184,  178,  188,   24,  178,  178,
       42,  178,   90,   91,   93,  178,   96,   97,  178,   18,

      189,   24,  178,  178,  178,  178,  178,  178,  178,  178,
      178,  178,  178,  178,  178,  187,   24,   24,   24,   24,
       24,   24,   24,   24,  178,  178,  178,  190,   24,  191,
       18,  191,  192,  178,   98,   98,  193,   18,  194,  178,
       24,  178,  178,  178,  178,  178,  178,   24,   24,   24,
       24,  178,   18,  178,  178,   18,  178,  178,  178,  178,
      178,  178,  178,  178,  178,  178,  195,  178,  178,  178,
      196,  178,  178,  178,  178,  197,  197,    0,  178,  178,
      178,  178,  178,  178,  178,  178,  178,  178,  178,  178,
      178,  178,  178,  178,  178,  178,  178

    } ;

static yyconst short int yy_nxt[599] =
    {   0,
       10,   11,   12,   13,   14,   15,   16,   17,   18,   19,
       20,   21,   21,   21,   21,   21,   21,   21,   10,   22,
       23,   24,   24,   25,   26,   24,   24,   24,   24,   27,
       28,   29,   24,   24,   30,   10,   31,   24,   25,   32,
       24,   24,   24,   24,   33,   34,   35,   24,   24,   36,
       37,   74,   74,   38,   38,   38,   38,   38,   38,   38,
       40,   40,   41,   42,   42,   42,   42,   40,   40,   41,
       42,   42,   42,   42,   64,   93,   94,   94,   65,   65,
       65,   68,   68,   89,   39,   43,   44,   64,   66,   45,
       45,   46,   47,   47,   47,   47,   68,   68,   99,   64,

       64,   66,   89,   66,   71,   71,   71,   71,   71,   71,
       71,   48,   49,   66,   66,  101,   66,  178,   86,   64,
      174,   50,  114,  114,   86,   64,  178,  174,   66,   66,
       51,   52,   99,   66,  178,   53,   86,   64,  170,   66,
       54,   55,   56,  178,  137,  138,  138,   57,   66,  101,
       58,   66,   51,   51,   66,   59,   60,   61,   71,   71,
       71,   71,   71,   71,   71,   51,   66,  137,  137,  137,
      137,   73,   74,   74,   51,   89,   75,   75,   75,   75,
       75,   75,   75,   89,   71,   71,   71,   71,   71,   71,
       71,   64,  157,   90,   90,   90,   90,   90,   91,   91,

       92,  161,  160,  159,  158,   66,  113,  113,  113,  113,
      113,  113,  113,   75,   75,   75,   75,   75,   75,   75,
       66,   89,  125,  126,  127,  127,  127,  127,  127,   64,
      170,   95,   95,   95,   95,   95,   65,   65,   92,  155,
      154,   99,   86,   66,  132,  132,  132,  132,  132,  133,
      133,  133,  133,  133,  134,  134,  140,  140,   66,   64,
      120,   96,   96,   97,   98,   98,   98,   98,  131,  131,
      131,  131,  131,   66,  113,  113,  113,  113,  113,  113,
      113,  115,  115,  115,  115,  115,  115,  115,   66,   99,
      115,  115,  115,  115,  115,  115,  115,   64,  120,  100,

      100,  100,  100,  100,  100,  100,  101,  120,  120,  165,
       51,   66,   71,   71,   71,   71,   71,   71,   71,  127,
      127,  127,  127,  127,  127,  152,   66,   89,  127,  127,
      127,   86,   64,   89,  164,   64,  174,  130,  130,  130,
      130,  130,  131,  131,   92,   89,   66,  155,  178,   66,
      157,   89,  159,  176,  163,   64,   64,   51,  162,  176,
       64,   66,  161,  160,   66,   99,  174,  175,  160,   66,
       66,  159,  158,   64,   66,  135,  135,  135,  135,  135,
      136,  136,  101,  158,   66,   66,  155,   66,  174,   66,
      166,  167,  167,  168,  169,  169,  169,  175,  169,  169,

      154,  152,   66,  171,  171,  171,  171,  171,  172,  173,
      169,  169,  169,  169,  169,  169,   89,  151,  120,  175,
      150,  149,   70,   69,  176,  120,  173,   62,   62,  148,
       62,   62,   62,   62,   62,   62,   62,   62,   65,   65,
      147,   51,   65,   67,   50,  146,   67,   72,  145,   72,
       72,   72,   85,   85,  144,   51,   85,   87,   87,   87,
       50,  143,   87,  113,  113,  142,  113,  115,  115,  141,
      115,  116,   99,  116,  116,  116,  128,  128,  128,   89,
      129,  128,  139,  124,  120,  119,  123,  139,  153,  153,
      153,  122,  121,  153,  156,  120,  119,  118,  156,  156,

      117,   70,  156,  134,   69,  112,  111,  110,  134,  134,
      138,  109,  108,  107,  138,  138,  106,  105,  138,  140,
      104,  103,   70,   69,  140,  169,  102,   88,   84,   83,
      169,   82,   81,   80,  169,  173,   79,   78,   77,  173,
      173,  177,   76,   70,   69,   63,  177,  178,    9,  178,
      178,  178,  178,  178,  178,  178,  178,  178,  178,  178,
      178,  178,  178,  178,  178,  178,  178,  178,  178,  178,
      178,  178,  178,  178,  178,  178,  178,  178,  178,  178,
      178,  178,  178,  178,  178,  178,  178,  178,  178,  178,
      178,  178,  178,  178,  178,  178,  178,  178

    } ;

static yyconst short int yy_chk[599] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    3,
        3,   66,   66,    3,    3,    3,    3,    3,    3,    3,
        5,    5,    5,    5,    5,    5,    5,    6,    6,    6,
        6,    6,    6,    6,   17,   41,   41,   41,   46,   46,
       46,   19,   64,  177,    3,    7,    7,   18,   17,    7,
        7,    7,    7,    7,    7,    7,   19,   64,   47,   36,

       37,   18,  176,   17,   24,   24,   24,   24,   24,   24,
       24,    7,   11,   36,   37,   47,   18,   93,   38,   38,
      175,   11,   68,   68,   85,   85,   94,  174,   36,   37,
       11,   11,  100,   38,   93,   11,   87,   87,  170,   85,
       11,   11,   11,   94,   97,   97,   97,   11,   38,  100,
       11,   87,  165,  164,   85,   11,   11,   11,   23,   23,
       23,   23,   23,   23,   23,  163,   87,   98,   98,   98,
       98,   23,   25,   25,  162,  133,   25,   25,   25,   25,
       25,   25,   25,   40,   71,   71,   71,   71,   71,   71,
       71,   40,  133,   40,   40,   40,   40,   40,   40,   40,

       40,  161,  160,  159,  158,   40,   74,   74,   74,   74,
       74,   74,   74,   75,   75,   75,   75,   75,   75,   75,
       40,   42,   86,   86,   86,   86,   86,   86,   86,   42,
      156,   42,   42,   42,   42,   42,   42,   42,   42,  155,
      154,  101,  153,   42,   91,   91,   91,   91,   91,   92,
       92,   92,   92,   92,   92,   92,  101,  101,   42,   43,
      151,   43,   43,   43,   43,   43,   43,   43,   95,   95,
       95,   95,   95,   43,  113,  113,  113,  113,  113,  113,
      113,  114,  114,  114,  114,  114,  114,  114,   43,   45,
      115,  115,  115,  115,  115,  115,  115,   45,  150,   45,

       45,   45,   45,   45,   45,   45,   45,  149,  148,  147,
      146,   45,  116,  116,  116,  116,  116,  116,  116,  125,
      125,  125,  125,  125,  125,  126,   45,   90,  126,  126,
      126,  128,  128,  134,  145,   90,  167,   90,   90,   90,
       90,   90,   90,   90,   90,  171,  128,  130,  132,   90,
      134,  173,  137,  171,  144,  130,  132,  143,  142,  173,
      137,  128,  141,  140,   90,   96,  169,  167,  139,  130,
      132,  138,  136,   96,  137,   96,   96,   96,   96,   96,
       96,   96,   96,  135,  130,  132,  131,   96,  168,  137,
      152,  152,  152,  152,  152,  152,  152,  169,  168,  168,

      129,  127,   96,  157,  157,  157,  157,  157,  157,  157,
      166,  166,  166,  166,  166,  166,  172,  124,  123,  168,
      122,  121,  120,  119,  172,  118,  172,  179,  179,  117,
      179,  179,  179,  179,  179,  179,  179,  179,  180,  180,
      112,  111,  180,  181,  110,  109,  181,  182,  108,  182,
      182,  182,  183,  183,  107,  106,  183,  184,  184,  184,
      105,  104,  184,  185,  185,  103,  185,  186,  186,  102,
      186,  187,   99,  187,  187,  187,  188,  188,  188,   89,
       88,  188,  189,   84,   83,   82,   81,  189,  190,  190,
      190,   80,   79,  190,  191,   78,   77,   76,  191,  191,

       73,   70,  191,  192,   69,   61,   60,   59,  192,  192,
      193,   58,   57,   56,  193,  193,   55,   54,  193,  194,
       53,   52,   51,   50,  194,  195,   48,   39,   35,   34,
      195,   33,   32,   31,  195,  196,   29,   28,   27,  196,
      196,  197,   26,   22,   20,   16,  197,    9,  178,  178,
      178,  178,  178,  178,  178,  178,  178,  178,  178,  178,
      178,  178,  178,  178,  178,  178,  178,  178,  178,  178,
      178,  178,  178,  178,  178,  178,  178,  178,  178,  178,
      178,  178,  178,  178,  178,  178,  178,  178,  178,  178,
      178,  178,  178,  178,  178,  178,  178,  178

    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
char *yytext;
#line 1 "utscan.l"
#define INITIAL 0
#line 2 "utscan.l"

/*
 * lex(1) specification for tokens for the Unidata units package, udunits.
 */

#ifndef _XOPEN_SOURCE
#   define _XOPEN_SOURCE
#endif
#ifndef _ANSI_C_SOURCE
#   define _ANSI_C_SOURCE
#endif

#include <udposix.h>
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <errno.h>
#include <math.h>
#include <time.h>
#include "udunits.h"
#include "utprivate.h"	/* private definitions */
#include "utparse.h"	/* #include "udunits.h" before this one */
#include "utscan.h"

#define shift_seen 1
#define date_seen 2
#define time_seen 3


/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap YY_PROTO(( void ));
#else
extern int yywrap YY_PROTO(( void ));
#endif
#endif

#ifndef YY_NO_UNPUT
static void yyunput YY_PROTO(( int c, char *buf_ptr ));
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy YY_PROTO(( char *, yyconst char *, int ));
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif
#endif

#if YY_STACK_USED
static int yy_start_stack_ptr = 0;
static int yy_start_stack_depth = 0;
static int *yy_start_stack = 0;
#ifndef YY_NO_PUSH_STATE
static void yy_push_state YY_PROTO(( int new_state ));
#endif
#ifndef YY_NO_POP_STATE
static void yy_pop_state YY_PROTO(( void ));
#endif
#ifndef YY_NO_TOP_STATE
static int yy_top_state YY_PROTO(( void ));
#endif

#else
#define YY_NO_PUSH_STATE 1
#define YY_NO_POP_STATE 1
#define YY_NO_TOP_STATE 1
#endif

#ifdef YY_MALLOC_DECL
YY_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( yy_current_buffer->yy_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else if ( ((result = fread( buf, 1, max_size, yyin )) == 0) \
		  && ferror( yyin ) ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );
#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL int yylex YY_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

YY_DECL
	{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;

#line 44 "utscan.l"



	if ( yy_init )
		{
		yy_init = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yy_start )
			yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! yy_current_buffer )
			yy_current_buffer =
				yy_create_buffer( yyin, YY_BUF_SIZE );

		yy_load_buffer_state();
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start;
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				yy_last_accepting_state = yy_current_state;
				yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 179 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 549 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yy_hold_char;
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 46 "utscan.l"
{
    /* comment */ ;
}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 50 "utscan.l"
{
    BEGIN shift_seen;
    return SHIFT;
}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 55 "utscan.l"
{
    BEGIN 0;
    return DIVIDE;
}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 60 "utscan.l"
{
    BEGIN 0;
    return MULTIPLY;
}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 65 "utscan.l"
{
    BEGIN 0;
    return EXPONENT;
}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 70 "utscan.l"
{
    int		year;
    int		month;
    int		day;

    (void) sscanf((char*)yytext, "%d-%d-%d", &year, &month, &day);
    yylval.rval	= utencdate(year, month, day);

    BEGIN date_seen;
    return DATE;
}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 82 "utscan.l"
{
    time_t	now;
    struct tm	*tp;

    errno	= 0;
    if (time(&now) == -1) {
	(void) fprintf(stderr, "udunits(3): Can't get current time. %s\n",
		       strerror(errno));
	return ERR;
    }

    if ((tp = gmtime(&now)) == NULL) {
	(void) fprintf(stderr, "udunits(3): can't get UTC time\n");
	return ERR;
    }
    yylval.rval	= utencdate(1900+tp->tm_year, 1+tp->tm_mon, tp->tm_mday) +
		  utencclock(tp->tm_hour, tp->tm_min, (double)tp->tm_sec);

    BEGIN 0;
    return REAL;
}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 104 "utscan.l"
{
    int		hour;
    int		minute	= 0;
    double	second	= 0.0;

    (void) sscanf((char*)yytext, "%d:%d:%lf", &hour, &minute, &second);
    yylval.rval	= utencclock(hour, minute, second);

    BEGIN time_seen;
    return TIME;
}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 116 "utscan.l"
{
    int		hour;
    int		minute;

    (void) sscanf((char*)yytext, "%2d%2d", &hour, &minute);
    if (hour >= 24 || minute >= 60)
	return ERR;
    yylval.rval	= utencclock(hour, minute, 0.0);

    BEGIN time_seen;
    return TIME;
}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 129 "utscan.l"
{
    int		hour;
    int		minute;

    (void) sscanf((char*)yytext, "%1d%2d", &hour, &minute);
    if (minute >= 60)
	return ERR;
    yylval.rval	= utencclock(hour, minute, 0.0);

    BEGIN time_seen;
    return TIME;
}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 142 "utscan.l"
{
    yylval.rval	= 0;

    BEGIN 0;
    return ZONE;
}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 149 "utscan.l"
{
    int		hour;
    int		minute;

    (void) sscanf((char*)yytext, "%d:%d", &hour, &minute);
    if (hour < 0)
	minute	= -minute;

    yylval.rval	= utencclock(hour, minute, 0.0);

    BEGIN 0;
    return ZONE;
}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 163 "utscan.l"
{
    int		hour;

    (void) sscanf((char*)yytext, "%d", &hour);

    yylval.rval	= utencclock(hour, 0, 0.0);

    BEGIN 0;
    return ZONE;
}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 174 "utscan.l"
{
    int		zone;
    int		hour;
    int		minute;

    (void) sscanf((char*)yytext, "%d", &zone);
    minute	= zone < 0
		    ? -(-zone % 100)
		    :    zone % 100;
    hour	= (zone - minute) / 100;

    yylval.rval	= utencclock(hour, minute, 0.0);

    BEGIN 0;
    return ZONE;
}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 191 "utscan.l"
{
    if (strlen((char*)yytext) > UT_NAMELEN-1)
	(void) fprintf(stderr, "udunits(3): Name `%s' too long; truncated\n",
		       yytext);
    (void) strncpy(yylval.name, (char*)yytext, UT_NAMELEN-1);
    yylval.name[UT_NAMELEN-1]	= 0;

    BEGIN 0;
    return NAME;
}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 202 "utscan.l"
{
    int		status;

    errno	= 0;
    yylval.ival = atol((char*)yytext);
    if (errno == 0) {
	status	= INT;
    } else {
	(void) fputs("udunits(3): Invalid integer\n", stderr);
	status	= ERR;
    }

    BEGIN 0;
    return status;
}
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 218 "utscan.l"
{
    int		status;

    errno	= 0;
    yylval.rval = atof((char*)yytext);
    if (errno == 0) {
	status	= REAL;
    } else {
	(void) fputs("udunits(3): Invalid real\n", stderr);
	status	= ERR;
    }

    BEGIN 0;
    return status;
}
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 234 "utscan.l"
{
    BEGIN 0;
    return yytext[0];
}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 239 "utscan.l"
{
    return yytext[0];
}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 243 "utscan.l"
ECHO;
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(shift_seen):
case YY_STATE_EOF(date_seen):
case YY_STATE_EOF(time_seen):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yy_hold_char;

		if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between yy_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yy_n_chars = yy_current_buffer->yy_n_chars;
			yy_current_buffer->yy_input_file = yyin;
			yy_current_buffer->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yy_c_buf_p = yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yy_did_buffer_switch_on_eof = 0;

				if ( yywrap() )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yy_c_buf_p = yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yy_c_buf_p =
					yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yy_c_buf_p =
				&yy_current_buffer->yy_ch_buf[yy_n_chars];

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of yylex */


/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int yy_get_next_buffer()
	{
	register char *dest = yy_current_buffer->yy_ch_buf;
	register char *source = yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( yy_current_buffer->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yy_c_buf_p - yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a singled characater, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yy_c_buf_p - yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		yy_n_chars = 0;

	else
		{
		int num_to_read =
			yy_current_buffer->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef YY_USES_REJECT
			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = yy_current_buffer;

			int yy_c_buf_p_offset =
				(int) (yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yy_flex_realloc( (void *) b->yy_ch_buf,
							 b->yy_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = yy_current_buffer->yy_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
			yy_n_chars, num_to_read );
		}

	if ( yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			yy_current_buffer->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	yy_n_chars += number_to_move;
	yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yytext_ptr = &yy_current_buffer->yy_ch_buf[0];

	return ret_val;
	}


/* yy_get_previous_state - get the state just before the EOB char was reached */

static yy_state_type yy_get_previous_state()
	{
	register yy_state_type yy_current_state;
	register char *yy_cp;

	yy_current_state = yy_start;

	for ( yy_cp = yytext_ptr + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yy_last_accepting_state = yy_current_state;
			yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 179 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
	}


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static yy_state_type yy_try_NUL_trans( yy_state_type yy_current_state )
#else
static yy_state_type yy_try_NUL_trans( yy_current_state )
yy_state_type yy_current_state;
#endif
	{
	register int yy_is_jam;
	register char *yy_cp = yy_c_buf_p;

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yy_last_accepting_state = yy_current_state;
		yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 179 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 178);

	return yy_is_jam ? 0 : yy_current_state;
	}


#ifndef YY_NO_UNPUT
#ifdef YY_USE_PROTOS
static void yyunput( int c, register char *yy_bp )
#else
static void yyunput( c, yy_bp )
int c;
register char *yy_bp;
#endif
	{
	register char *yy_cp = yy_c_buf_p;

	/* undo effects of setting up yytext */
	*yy_cp = yy_hold_char;

	if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = yy_n_chars + 2;
		register char *dest = &yy_current_buffer->yy_ch_buf[
					yy_current_buffer->yy_buf_size + 2];
		register char *source =
				&yy_current_buffer->yy_ch_buf[number_to_move];

		while ( source > yy_current_buffer->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		yy_n_chars = yy_current_buffer->yy_buf_size;

		if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;


	yytext_ptr = yy_bp;
	yy_hold_char = *yy_cp;
	yy_c_buf_p = yy_cp;
	}
#endif	/* ifndef YY_NO_UNPUT */


#ifdef __cplusplus
static int yyinput()
#else
static int input()
#endif
	{
	int c;

	*yy_c_buf_p = yy_hold_char;

	if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			/* This was really a NUL. */
			*yy_c_buf_p = '\0';

		else
			{ /* need more input */
			yytext_ptr = yy_c_buf_p;
			++yy_c_buf_p;

			switch ( yy_get_next_buffer() )
				{
				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap() )
						{
						yy_c_buf_p =
						yytext_ptr + YY_MORE_ADJ;
						return EOF;
						}

					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yy_c_buf_p = yytext_ptr + YY_MORE_ADJ;
					break;

				case EOB_ACT_LAST_MATCH:
#ifdef __cplusplus
					YY_FATAL_ERROR(
					"unexpected last match in yyinput()" );
#else
					YY_FATAL_ERROR(
					"unexpected last match in input()" );
#endif
				}
			}
		}

	c = *(unsigned char *) yy_c_buf_p;	/* cast for 8-bit char's */
	*yy_c_buf_p = '\0';	/* preserve yytext */
	yy_hold_char = *++yy_c_buf_p;


	return c;
	}


#ifdef YY_USE_PROTOS
void yyrestart( FILE *input_file )
#else
void yyrestart( input_file )
FILE *input_file;
#endif
	{
	if ( ! yy_current_buffer )
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

	yy_init_buffer( yy_current_buffer, input_file );
	yy_load_buffer_state();
	}


#ifdef YY_USE_PROTOS
void yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif
	{
	if ( yy_current_buffer == new_buffer )
		return;

	if ( yy_current_buffer )
		{
		/* Flush out information for old buffer. */
		*yy_c_buf_p = yy_hold_char;
		yy_current_buffer->yy_buf_pos = yy_c_buf_p;
		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	yy_current_buffer = new_buffer;
	yy_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yy_did_buffer_switch_on_eof = 1;
	}


#ifdef YY_USE_PROTOS
void yy_load_buffer_state( void )
#else
void yy_load_buffer_state()
#endif
	{
	yy_n_chars = yy_current_buffer->yy_n_chars;
	yytext_ptr = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
	yyin = yy_current_buffer->yy_input_file;
	yy_hold_char = *yy_c_buf_p;
	}


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE yy_create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yy_flex_alloc( b->yy_buf_size + 2 );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
	}


#ifdef YY_USE_PROTOS
void yy_delete_buffer( YY_BUFFER_STATE b )
#else
void yy_delete_buffer( b )
YY_BUFFER_STATE b;
#endif
	{
	if ( ! b )
		return;

	if ( b == yy_current_buffer )
		yy_current_buffer = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yy_flex_free( (void *) b->yy_ch_buf );

	yy_flex_free( (void *) b );
	}


#ifndef YY_ALWAYS_INTERACTIVE
#ifndef YY_NEVER_INTERACTIVE
extern int isatty YY_PROTO(( int ));
#endif
#endif

#ifdef YY_USE_PROTOS
void yy_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif


	{
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

#if YY_ALWAYS_INTERACTIVE
	b->yy_is_interactive = 1;
#else
#if YY_NEVER_INTERACTIVE
	b->yy_is_interactive = 0;
#else
	b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
#endif
#endif
	}


#ifdef YY_USE_PROTOS
void yy_flush_buffer( YY_BUFFER_STATE b )
#else
void yy_flush_buffer( b )
YY_BUFFER_STATE b;
#endif

	{
	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == yy_current_buffer )
		yy_load_buffer_state();
	}


#ifndef YY_NO_SCAN_BUFFER
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_buffer( char *base, yy_size_t size )
#else
YY_BUFFER_STATE yy_scan_buffer( base, size )
char *base;
yy_size_t size;
#endif
	{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b );

	return b;
	}
#endif


#ifndef YY_NO_SCAN_STRING
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_string( yyconst char *str )
#else
YY_BUFFER_STATE yy_scan_string( str )
yyconst char *str;
#endif
	{
	int len;
	for ( len = 0; str[len]; ++len )
		;

	return yy_scan_bytes( str, len );
	}
#endif


#ifndef YY_NO_SCAN_BYTES
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_bytes( yyconst char *bytes, int len )
#else
YY_BUFFER_STATE yy_scan_bytes( bytes, len )
yyconst char *bytes;
int len;
#endif
	{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) yy_flex_alloc( n );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef YY_NO_PUSH_STATE
#ifdef YY_USE_PROTOS
static void yy_push_state( int new_state )
#else
static void yy_push_state( new_state )
int new_state;
#endif
	{
	if ( yy_start_stack_ptr >= yy_start_stack_depth )
		{
		yy_size_t new_size;

		yy_start_stack_depth += YY_START_STACK_INCR;
		new_size = yy_start_stack_depth * sizeof( int );

		if ( ! yy_start_stack )
			yy_start_stack = (int *) yy_flex_alloc( new_size );

		else
			yy_start_stack = (int *) yy_flex_realloc(
					(void *) yy_start_stack, new_size );

		if ( ! yy_start_stack )
			YY_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	yy_start_stack[yy_start_stack_ptr++] = YY_START;

	BEGIN(new_state);
	}
#endif


#ifndef YY_NO_POP_STATE
static void yy_pop_state()
	{
	if ( --yy_start_stack_ptr < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(yy_start_stack[yy_start_stack_ptr]);
	}
#endif


#ifndef YY_NO_TOP_STATE
static int yy_top_state()
	{
	return yy_start_stack[yy_start_stack_ptr - 1];
	}
#endif

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

#ifdef YY_USE_PROTOS
static void yy_fatal_error( yyconst char msg[] )
#else
static void yy_fatal_error( msg )
char msg[];
#endif
	{
	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
	}



/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		yytext[yyleng] = yy_hold_char; \
		yy_c_buf_p = yytext + n - YY_MORE_ADJ; \
		yy_hold_char = *yy_c_buf_p; \
		*yy_c_buf_p = '\0'; \
		yyleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef yytext_ptr
#ifdef YY_USE_PROTOS
static void yy_flex_strncpy( char *s1, yyconst char *s2, int n )
#else
static void yy_flex_strncpy( s1, s2, n )
char *s1;
yyconst char *s2;
int n;
#endif
	{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif


#ifdef YY_USE_PROTOS
static void *yy_flex_alloc( yy_size_t size )
#else
static void *yy_flex_alloc( size )
yy_size_t size;
#endif
	{
	return (void *) malloc( size );
	}

#ifdef YY_USE_PROTOS
static void *yy_flex_realloc( void *ptr, yy_size_t size )
#else
static void *yy_flex_realloc( ptr, size )
void *ptr;
yy_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
	}

#ifdef YY_USE_PROTOS
static void yy_flex_free( void *ptr )
#else
static void yy_flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}

#if YY_MAIN
int main()
	{
	yylex();
	return 0;
	}
#endif
#line 243 "utscan.l"


    void
utLexReset()
{
    BEGIN 0;
}
