/*

Copyright (C) 2000, 2001 Christian Kreibich <kreibich@aciri.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#ifdef LINUX
#define __FAVOR_BSD
#endif

#include <gtk/gtk.h>
#include <nd.h>
#include <nd_gui.h>
#include <nd_globals.h>
#include <nd_packet.h>
#include <nd_tracefile.h>
#include <support.h>

int opts_table_x;
int opts_table_y;


static void
generic_table_add_option(GtkWidget *t, char *label,
			 char *tooltip, int size)
{
  GList        *opt_widgets;
  GtkWidget    *w;
  GtkTooltips  *tt;
  int           num_rows;
  int           num_cols;
  int           label_done = 0;

  D_ASSERT(t);
  opt_widgets = gtk_object_get_data(GTK_OBJECT(t), "opt_widgets");
  tt = gtk_object_get_data(GTK_OBJECT(toplevel), "tooltips");
  D_ASSERT(tt);

  if (opts_table_x + size > 32)
    {
      /* We're going to use at least two rows */

      w = gtk_button_new_with_label ("");
      gtk_widget_ref(w);
      gtk_widget_show(w);
      gtk_table_attach (GTK_TABLE(t), w,
			opts_table_x, 32,
			opts_table_y, opts_table_y + 1,
			(GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
			(GtkAttachOptions) (0), 0, 0);

      opt_widgets = g_list_append(opt_widgets, w);

      size -= (32 - opts_table_x);
      opts_table_x = 0;
      opts_table_y++;

      /* Check how many rows/cols we still need to cover */

      num_rows = size / 32;
      num_cols = size - (num_rows*32);

      if (GTK_TABLE(t)->nrows < opts_table_y + num_rows + 2)
	gtk_table_resize(GTK_TABLE(t), opts_table_y + num_rows + 2, GTK_TABLE(t)->ncols);

      w = gtk_button_new_with_label(label);
      gtk_widget_ref(w);
      gtk_widget_show(w);
      gtk_tooltips_set_tip(tt, w, tooltip, NULL);

      label_done = 1;
      
      if (num_rows > 0)
	{
	  gtk_table_attach (GTK_TABLE(t), w,
			    0, 32,
			    opts_table_y, opts_table_y + num_rows + 1,
			    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
			    (GtkAttachOptions) (GTK_FILL), 0, 0);

	  opts_table_x = 0;
	  opts_table_y += num_rows;
	}
      else
	{
	  gtk_table_attach (GTK_TABLE(t), w,
			    opts_table_x, opts_table_x + num_cols,
			    opts_table_y, opts_table_y + 1,
			    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
			    (GtkAttachOptions) (GTK_FILL), 0, 0);

	  opts_table_x += num_cols;
	}

      size -= (32 * num_rows) + num_cols;
      opt_widgets = g_list_append(opt_widgets, w);
    }

  if (size > 0)
    {
      if (label_done)
	{
	  w = gtk_button_new_with_label("");
	}
      else
	{
	  w = gtk_button_new_with_label(label);
	  gtk_tooltips_set_tip(tt, w, tooltip, NULL);
	}
      
      gtk_widget_ref(w);
      gtk_widget_show(w);
      
      gtk_table_attach (GTK_TABLE(t), w,
			opts_table_x, opts_table_x + size,
			opts_table_y, opts_table_y + 1,
			(GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
			(GtkAttachOptions) (0), 0, 0);
      
      opt_widgets = g_list_append(opt_widgets, w);
      opts_table_x += size;

      /* Resize the button to something really narrow -- it will get
	 resized to the narrowest existing buttons since the tables
	 are homogeneously spaced ... this probably should be handled
	 differently, but works great.
      */
      gtk_widget_set_usize(GTK_WIDGET(w), 1, -1);
    }	 

  gtk_object_set_data(GTK_OBJECT(t), "opt_widgets", opt_widgets);
}


static void    
nd_gui_generic_table_clear_options(char *table)
{
  GtkWidget  *w;
  GList      *opt_widgets;

  w = gtk_object_get_data(GTK_OBJECT(toplevel), table);
  D_ASSERT(w);
  opt_widgets = gtk_object_get_data(GTK_OBJECT(w), "opt_widgets");

  if (opt_widgets)
    {
      GList *l;

      l = g_list_first(opt_widgets);
      while (l)
	{
	  gtk_container_remove(GTK_CONTAINER(w), GTK_WIDGET(l->data));
	  gtk_widget_destroy(GTK_WIDGET(l->data));
	  /* l->data = NULL; */
	  l = g_list_next(l);
	}

      g_list_free(opt_widgets);
    }

  gtk_object_set_data(GTK_OBJECT(w), "opt_widgets", NULL);
}


void    
nd_gui_tcp_table_clear_options(void)
{
  opts_table_x = 0;
  opts_table_y = 5;
  nd_gui_generic_table_clear_options("tcp_table");
}

void    
nd_gui_ip_table_clear_options(void)
{
  opts_table_x = 0;
  opts_table_y = 5;
  nd_gui_generic_table_clear_options("ip_table");
}


void    
nd_gui_ip_table_add_option(char *label, char *tooltip, int size)
{
  GtkWidget *w;

  w = gtk_object_get_data(GTK_OBJECT(toplevel), "ip_table");
  D_ASSERT(w);
  generic_table_add_option(w, label, tooltip, size);
}


void    
nd_gui_tcp_table_add_option(char *label, char *tooltip, int size)
{
  GtkWidget *w;

  w = gtk_object_get_data(GTK_OBJECT(toplevel), "tcp_table");
  D_ASSERT(w);
  generic_table_add_option(w, label, tooltip, size);
}


void    
nd_gui_icmp_table_clear(void)
{
}


void    
nd_gui_icmp_table_set(ND_Packet *p)
{
}


void    
nd_gui_arp_table_adjust(int hard_len, int prot_len)
{
  GtkWidget *table, *b;

  table = gtk_object_get_data(GTK_OBJECT(toplevel), "arp_table");
  D_ASSERT(table);

  b = gtk_object_get_data(GTK_OBJECT(toplevel), "arp_sender_link");
  D_ASSERT(b);
  gtk_container_remove(GTK_CONTAINER(table), GTK_WIDGET(b));
  gtk_table_attach(GTK_TABLE(table), b,
		   8,
		   8 + hard_len, 0, 1,
		   (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		   (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  b = gtk_object_get_data(GTK_OBJECT(toplevel), "arp_sender_net");
  D_ASSERT(b);
  gtk_container_remove(GTK_CONTAINER(table), GTK_WIDGET(b));
  gtk_table_attach(GTK_TABLE(table), b,
		   8 + hard_len,
		   8 + hard_len + prot_len, 0, 1,
		   (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		   (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  b = gtk_object_get_data(GTK_OBJECT(toplevel), "arp_target_link");
  D_ASSERT(b);
  gtk_container_remove(GTK_CONTAINER(table), GTK_WIDGET(b));
  gtk_table_attach(GTK_TABLE(table), b,
		   8 + hard_len + prot_len,
		   8 + hard_len + prot_len + hard_len, 0, 1,
		   (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		   (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  b = gtk_object_get_data(GTK_OBJECT(toplevel), "arp_target_net");
  D_ASSERT(b);
  gtk_container_remove(GTK_CONTAINER(table), GTK_WIDGET(b));
  gtk_table_attach(GTK_TABLE(table), b,
		   8 + hard_len + prot_len + hard_len,
		   8 + hard_len + prot_len + hard_len + prot_len, 0, 1,
		   (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		   (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
}

