/*

Copyright (C) 2000, 2001 Christian Kreibich <kreibich@aciri.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#ifdef LINUX
#define __FAVOR_BSD
#endif
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/udp.h>

#ifdef FREEBSD
#include <netinet/ip_var.h>
#include <netinet/udp_var.h>
#endif

#include <gtk/gtk.h>
#include <nd.h>
#include <nd_ip.h>
#include <nd_packet.h>
#include <nd_globals.h>
#include <nd_misc.h>
#include <nd_udp.h>
#include <interface.h>
#include <support.h>


void    
udp_sport(u_int16_t value)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (nd_packet_has_protocol(p, ND_PROT_UDP))
	{
	  nd_packet_udp(p)->uh_sport = htons(value);
	  udp_recalc_checksum(p);
	}
    }
  nd_misc_pbar_clear();
  if (trace.p)
    nd_packet_set_udp(trace.p, 0);
}


void    
udp_dport(u_int16_t value)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (nd_packet_has_protocol(p, ND_PROT_UDP))
	{
	  nd_packet_udp(p)->uh_dport = htons(value);
	  udp_recalc_checksum(p);
	}
    }
  nd_misc_pbar_clear();
  if (trace.p)
    nd_packet_set_udp(trace.p, 0);
}


void    
udp_ulen(u_int16_t value)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (nd_packet_has_protocol(p, ND_PROT_UDP))
	{
	  nd_packet_udp(p)->uh_ulen = htons(value);
	  udp_recalc_checksum(p);
	}
    }
  nd_misc_pbar_clear();
  if (trace.p)
    nd_packet_set_udp(trace.p, 0);
}


void    
udp_sum(u_int16_t value)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (nd_packet_has_protocol(p, ND_PROT_UDP))
	{
	  nd_packet_udp(p)->uh_sum = htons(value);
	  nd_trace_set_dirty(TRUE);
	}
    }
  nd_misc_pbar_clear();
  if (trace.p)
    nd_packet_set_udp(trace.p, 0);
}


void    
udp_recalc_checksum(ND_Packet *p)
{
  if (nd_packet_has_protocol(p, ND_PROT_UDP))
    {
      nd_packet_udp(p)->uh_sum = nd_misc_udp_checksum(p);
      nd_trace_set_dirty(TRUE);
    }
}
