/*

Copyright (C) 2000, 2001 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_ipfrag_h
#define __nd_ipfrag_h

#include <gtk/gtk.h>
#include <netdude/nd_packet.h>

/* Helper structure containing fragmentation data: */

typedef struct nd_frag_data
{
  GtkWidget *dialog;    /* The fragmentation dialog used to adjust settings */
  ND_Packet *packet;    /* The packet being fragmented */

  guint      size_orig; /* The original size of the IP packet payload */
  guint      size1;     /* The payload size of the first fragment */
  guint      size2;     /* The payload size of the second fragment */

  guint      offset1;   /* The payload offset of the first fragment  */
  guint      offset2;   /* The payload offset of the second fragment  */

} ND_FragData;


/* Fragments the given IP packet in two fragments of
   given sizes. The following sanity checks are made:
   
   - whether the packet containts IP
   - whether the fragment sizes sum up to the IP payload size
   - whether the fragment sizes are multiples of 8

   The second fragment is inserted after the original
   packet in the trace.
*/
void      nd_ip_frag_fragment(ND_Packet *packet, guint size1, guint size2);

/* Shows IP fragmentation dialog */
void      nd_ip_frag_show_dialog(ND_Packet *packet);

/* Callback to adjust the dialog's widgets */
void      nd_ip_frag_adjust(ND_FragData *data, int fragment_size, int fragment_num);

/* Cancel callback of the IP fragmentation dialog */
void      nd_ip_frag_cancel(ND_FragData *data);

/* OK callback, fragments packet */
void      nd_ip_frag_apply(ND_FragData *data);

void      nd_ip_frag_reassemble(ND_Packet *packet);

#endif
