/*
 	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com).
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


#include "Entity_CA_ASN1.h"
#include <PKI_ERR.h>
#include <openssl/asn1t.h>

ASN1_SEQUENCE(LOCAL_CA_CONF) = {
	ASN1_SIMPLE(LOCAL_CA_CONF, conf, ENTITY_CONF),
	ASN1_SIMPLE(LOCAL_CA_CONF, cas, INTERNAL_PKI_CA),
	ASN1_EXP_OPT(LOCAL_CA_CONF, privkey, INTERNAL_CA_KEY, 1),
	ASN1_EXP_SEQUENCE_OF(LOCAL_CA_CONF, parentCerts, X509, 2),
}ASN1_SEQUENCE_END(LOCAL_CA_CONF)
ASN1_SEQUENCE(LOCAL_CA_CONF_BETA4) = {
	ASN1_SIMPLE(LOCAL_CA_CONF_BETA4, conf, ENTITY_CONF_BETA4),
	ASN1_SIMPLE(LOCAL_CA_CONF_BETA4, cas, INTERNAL_PKI_CA),
	ASN1_EXP_OPT(LOCAL_CA_CONF_BETA4, privkey, INTERNAL_CA_KEY, 1),
	ASN1_EXP_SEQUENCE_OF(LOCAL_CA_CONF_BETA4, parentCerts, X509, 2),
}ASN1_SEQUENCE_END(LOCAL_CA_CONF_BETA4)
LocalCaConf LocalCaConf::EmptyInstance;
bool LocalCaConf::set_cas(const InternalPkiCa & c_cas)
{
	m_cas = c_cas;
	return true;
}

const InternalPkiCa & LocalCaConf::get_cas() const
{
	return m_cas;
}

InternalPkiCa & LocalCaConf::get_cas()
{
	return m_cas;
}

bool LocalCaConf::set_conf(const EntityConf & c_conf)
{
	m_conf = c_conf;
	return true;
}

const EntityConf & LocalCaConf::get_conf() const
{
	return m_conf;
}

EntityConf & LocalCaConf::get_conf()
{
	return m_conf;
}

bool LocalCaConf::set_parentcerts(const mVector< PKI_CERT > & c_parentcerts)
{
	m_parentcerts = c_parentcerts;
	return true;
}

const mVector< PKI_CERT > & LocalCaConf::get_parentcerts() const
{
	return m_parentcerts;
}

mVector< PKI_CERT > & LocalCaConf::get_parentcerts()
{
	return m_parentcerts;
}

bool LocalCaConf::set_privkey(const InternalCaKey & c_privkey)
{
	m_privkey = c_privkey;
	return true;
}

const InternalCaKey & LocalCaConf::get_privkey() const
{
	return m_privkey;
}

InternalCaKey & LocalCaConf::get_privkey()
{
	return m_privkey;
}

bool LocalCaConf::to_SignEncrypt(Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey, const EVP_MD * sig_md, const EVP_CIPHER * crypt_cypher) const
{
	LOCAL_CA_CONF * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, sig_pkey, crypt_pkey, sig_md, crypt_cypher))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool LocalCaConf::from_SignEncrypt(const Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey)
{
	LOCAL_CA_CONF * c_localvar = NULL;
	if(!Private_fromSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, sig_pkey, crypt_pkey))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

LocalCaConf::LocalCaConf():NewPKIObject(), LocalEntityConf()
{
	resetAll();
}

LocalCaConf::LocalCaConf(const LocalCaConf & other):NewPKIObject(), LocalEntityConf()
{
	resetAll();
	*this = other;
}

LocalCaConf::~LocalCaConf()
{
	Clear();
}

void LocalCaConf::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void LocalCaConf::freeAll()
{
}

void LocalCaConf::resetAll()
{
	m_cas.Clear();
	m_conf.Clear();
	m_parentcerts.clear();
	m_privkey.Clear();
}

bool LocalCaConf::load_Datas(const LOCAL_CA_CONF * Datas)
{
	Clear();
	int i;
	X509 * currparentcerts;
	if(Datas->cas)
	{
		if(!m_cas.load_Datas(Datas->cas))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->conf)
	{
		if(!m_conf.load_Datas(Datas->conf))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->parentCerts)
	{
		for(i=0; i<SKM_sk_num(X509, Datas->parentCerts); i++)
		{
			currparentcerts = SKM_sk_value(X509, Datas->parentCerts, i);
			if(!currparentcerts)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_parentcerts.insert(m_parentcerts.begin() + i);
			if(!m_parentcerts[i].load_Datas(currparentcerts))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->privkey)
	{
		if(!m_privkey.load_Datas(Datas->privkey))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool LocalCaConf::give_Datas(LOCAL_CA_CONF ** Datas) const
{
	if(!(*Datas) && !(*Datas = (LOCAL_CA_CONF*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	X509 * currparentcerts;
	size_t i;
	if(!(*Datas)->cas && !((*Datas)->cas = (INTERNAL_PKI_CA*)ASN1_item_new(ASN1_ITEM_rptr(INTERNAL_PKI_CA))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_cas.give_Datas(&(*Datas)->cas))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->cas, ASN1_ITEM_rptr(INTERNAL_PKI_CA));
		(*Datas)->cas = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->conf && !((*Datas)->conf = (ENTITY_CONF*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_conf.give_Datas(&(*Datas)->conf))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->conf, ASN1_ITEM_rptr(ENTITY_CONF));
		(*Datas)->conf = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->parentCerts && !((*Datas)->parentCerts = SKM_sk_new_null(X509)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_parentcerts.size() ; i++)
	{
		currparentcerts = NULL;
		if(!m_parentcerts[i].give_Datas(&currparentcerts))
		{
			ASN1_item_free((ASN1_VALUE*)currparentcerts, ASN1_ITEM_rptr(X509));
			currparentcerts = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(X509, (*Datas)->parentCerts, currparentcerts) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currparentcerts, ASN1_ITEM_rptr(X509));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(m_privkey)
	{
		if(!(*Datas)->privkey && !((*Datas)->privkey = (INTERNAL_CA_KEY*)ASN1_item_new(ASN1_ITEM_rptr(INTERNAL_CA_KEY))))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
		if(!m_privkey.give_Datas(&(*Datas)->privkey))
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->privkey, ASN1_ITEM_rptr(INTERNAL_CA_KEY));
			(*Datas)->privkey = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	else
	{
		if((*Datas)->privkey)
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->privkey, ASN1_ITEM_rptr(INTERNAL_CA_KEY));
			(*Datas)->privkey = NULL;
		}
	}
	return true;
}

bool LocalCaConf::operator=(const LocalCaConf & other)
{
	Clear();
	m_cas = other.m_cas;
	m_conf = other.m_conf;
	m_parentcerts = other.m_parentcerts;
	m_privkey = other.m_privkey;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * LocalCaConf::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(LOCAL_CA_CONF);
}
LocalCaConfBeta4 LocalCaConfBeta4::EmptyInstance;
bool LocalCaConfBeta4::set_cas(const InternalPkiCa & c_cas)
{
	m_cas = c_cas;
	return true;
}

const InternalPkiCa & LocalCaConfBeta4::get_cas() const
{
	return m_cas;
}

InternalPkiCa & LocalCaConfBeta4::get_cas()
{
	return m_cas;
}

bool LocalCaConfBeta4::set_conf(const EntityConfBeta4 & c_conf)
{
	m_conf = c_conf;
	return true;
}

const EntityConfBeta4 & LocalCaConfBeta4::get_conf() const
{
	return m_conf;
}

EntityConfBeta4 & LocalCaConfBeta4::get_conf()
{
	return m_conf;
}

bool LocalCaConfBeta4::set_parentcerts(const mVector< PKI_CERT > & c_parentcerts)
{
	m_parentcerts = c_parentcerts;
	return true;
}

const mVector< PKI_CERT > & LocalCaConfBeta4::get_parentcerts() const
{
	return m_parentcerts;
}

mVector< PKI_CERT > & LocalCaConfBeta4::get_parentcerts()
{
	return m_parentcerts;
}

bool LocalCaConfBeta4::set_privkey(const InternalCaKey & c_privkey)
{
	m_privkey = c_privkey;
	return true;
}

const InternalCaKey & LocalCaConfBeta4::get_privkey() const
{
	return m_privkey;
}

InternalCaKey & LocalCaConfBeta4::get_privkey()
{
	return m_privkey;
}

bool LocalCaConfBeta4::to_SignEncrypt(Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey, const EVP_MD * sig_md, const EVP_CIPHER * crypt_cypher) const
{
	LOCAL_CA_CONF_BETA4 * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, sig_pkey, crypt_pkey, sig_md, crypt_cypher))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool LocalCaConfBeta4::from_SignEncrypt(const Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey)
{
	LOCAL_CA_CONF_BETA4 * c_localvar = NULL;
	if(!Private_fromSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, sig_pkey, crypt_pkey))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

LocalCaConfBeta4::LocalCaConfBeta4():NewPKIObject(), LocalEntityConfBeta4()
{
	resetAll();
}

LocalCaConfBeta4::LocalCaConfBeta4(const LocalCaConfBeta4 & other):NewPKIObject(), LocalEntityConfBeta4()
{
	resetAll();
	*this = other;
}

LocalCaConfBeta4::~LocalCaConfBeta4()
{
	Clear();
}

void LocalCaConfBeta4::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void LocalCaConfBeta4::freeAll()
{
}

void LocalCaConfBeta4::resetAll()
{
	m_cas.Clear();
	m_conf.Clear();
	m_parentcerts.clear();
	m_privkey.Clear();
}

bool LocalCaConfBeta4::load_Datas(const LOCAL_CA_CONF_BETA4 * Datas)
{
	Clear();
	int i;
	X509 * currparentcerts;
	if(Datas->cas)
	{
		if(!m_cas.load_Datas(Datas->cas))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->conf)
	{
		if(!m_conf.load_Datas(Datas->conf))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->parentCerts)
	{
		for(i=0; i<SKM_sk_num(X509, Datas->parentCerts); i++)
		{
			currparentcerts = SKM_sk_value(X509, Datas->parentCerts, i);
			if(!currparentcerts)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_parentcerts.insert(m_parentcerts.begin() + i);
			if(!m_parentcerts[i].load_Datas(currparentcerts))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->privkey)
	{
		if(!m_privkey.load_Datas(Datas->privkey))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool LocalCaConfBeta4::give_Datas(LOCAL_CA_CONF_BETA4 ** Datas) const
{
	if(!(*Datas) && !(*Datas = (LOCAL_CA_CONF_BETA4*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	X509 * currparentcerts;
	size_t i;
	if(!(*Datas)->cas && !((*Datas)->cas = (INTERNAL_PKI_CA*)ASN1_item_new(ASN1_ITEM_rptr(INTERNAL_PKI_CA))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_cas.give_Datas(&(*Datas)->cas))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->cas, ASN1_ITEM_rptr(INTERNAL_PKI_CA));
		(*Datas)->cas = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->conf && !((*Datas)->conf = (ENTITY_CONF_BETA4*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF_BETA4))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_conf.give_Datas(&(*Datas)->conf))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->conf, ASN1_ITEM_rptr(ENTITY_CONF_BETA4));
		(*Datas)->conf = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->parentCerts && !((*Datas)->parentCerts = SKM_sk_new_null(X509)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_parentcerts.size() ; i++)
	{
		currparentcerts = NULL;
		if(!m_parentcerts[i].give_Datas(&currparentcerts))
		{
			ASN1_item_free((ASN1_VALUE*)currparentcerts, ASN1_ITEM_rptr(X509));
			currparentcerts = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(X509, (*Datas)->parentCerts, currparentcerts) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currparentcerts, ASN1_ITEM_rptr(X509));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(m_privkey)
	{
		if(!(*Datas)->privkey && !((*Datas)->privkey = (INTERNAL_CA_KEY*)ASN1_item_new(ASN1_ITEM_rptr(INTERNAL_CA_KEY))))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
		if(!m_privkey.give_Datas(&(*Datas)->privkey))
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->privkey, ASN1_ITEM_rptr(INTERNAL_CA_KEY));
			(*Datas)->privkey = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	else
	{
		if((*Datas)->privkey)
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->privkey, ASN1_ITEM_rptr(INTERNAL_CA_KEY));
			(*Datas)->privkey = NULL;
		}
	}
	return true;
}

bool LocalCaConfBeta4::operator=(const LocalCaConfBeta4 & other)
{
	Clear();
	m_cas = other.m_cas;
	m_conf = other.m_conf;
	m_parentcerts = other.m_parentcerts;
	m_privkey = other.m_privkey;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * LocalCaConfBeta4::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(LOCAL_CA_CONF_BETA4);
}
